/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType.generic;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.php.internal.ui.dialogs.openType.generic.ElementAddition;
import org.eclipse.php.internal.ui.dialogs.openType.generic.ISorter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.CompositeFilter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.IFilter;
import org.eclipse.php.internal.ui.dialogs.openType.generic.filter.IFilterChangeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HighLoadTableViewer
extends Composite {
    private TableViewer tableViewer;
    private Object[] elements = new Object[0];
    private Object[] sortedElements = this.elements;
    private Object[] tableElements = this.elements;
    private ISorter sorter = new ISorter(){

        public Object[] sort(Object[] elements) {
            return elements;
        }
    };
    private CompositeFilter compositeFilter = new CompositeFilter();
    private boolean defaultElementSelection = true;
    private ElementAddition elementAddition;

    public HighLoadTableViewer(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer((Composite)this, style);
        this.compositeFilter.addFilterChangeListener(new IFilterChangeListener(){

            public void notifyFilterChanged() {
                HighLoadTableViewer.this.applyFilter2TableViewer();
            }
        });
    }

    public void setElements(Object[] elements) {
        this.elements = elements;
        this.sortedElements = this.sorter.sort(elements);
        this.tableElements = this.compositeFilter.filter(this.sortedElements);
        this.addElementsToTableInNewThread();
    }

    public void setSorter(ISorter sorter) {
        this.sorter = sorter;
        this.sortedElements = sorter.sort(this.elements);
        this.tableElements = sorter.sort(this.tableElements);
        this.addElementsToTableInNewThread();
    }

    public void addFilter(IFilter filter) {
        this.compositeFilter.addFilter(filter);
    }

    private void applyFilter2TableViewer() {
        this.tableElements = this.compositeFilter.filter(this.sortedElements);
        this.addElementsToTableInNewThread();
    }

    private void addElementsToTableInNewThread() {
        if (this.elementAddition == null) {
            this.elementAddition = new ElementAddition(this.tableViewer, this.defaultElementSelection);
            Thread tableUpdater = new Thread(this.elementAddition);
            tableUpdater.start();
        }
        this.elementAddition.setElements(this.tableElements);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider(labelProvider);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public Object getElementAt(int index) {
        return this.tableViewer.getElementAt(index);
    }

    public void setSelection(IStructuredSelection selection) {
        this.tableViewer.setSelection((ISelection)selection);
    }

    public Object[] getTableElements() {
        return this.tableElements;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.tableViewer.addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void setDefaultElementSelection(boolean defaultElementSelection) {
        this.defaultElementSelection = defaultElementSelection;
    }

    public void close() {
        this.stopTableUpdater();
    }

    private void stopTableUpdater() {
        this.elementAddition.stop();
    }
}

