/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.GlobalNamespace;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.explorer.NamespaceNode;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.ui.ProjectLibraryRoot;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;
import org.eclipse.wst.jsdt.ui.project.JsNature;

public class PHPExplorerContentProvider
extends ScriptExplorerContentProvider
implements IIncludepathListener {
    StandardJavaScriptElementContentProvider jsContentProvider;

    public PHPExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        IncludePathManager.getInstance().registerIncludepathListener((IIncludepathListener)this);
        this.setIsFlatLayout(false);
        this.jsContentProvider = new StandardJavaScriptElementContentProvider(true);
    }

    public void setIsFlatLayout(boolean state) {
        super.setIsFlatLayout(false);
    }

    public void dispose() {
        super.dispose();
        IncludePathManager.getInstance().unregisterIncludepathListener((IIncludepathListener)this);
    }

    private Object[] getNonPhpProjects(IScriptModel model) throws ModelException {
        return model.getForeignResources();
    }

    public Object[] getChildren(Object parentElement) {
        Object entry;
        if (parentElement instanceof IncludePath && (entry = ((IncludePath)parentElement).getEntry()) instanceof IBuildpathEntry) {
            return this.getBuildPathEntryChildren(parentElement, entry);
        }
        if (parentElement instanceof ProjectLibraryRoot) {
            return ((ProjectLibraryRoot)parentElement).getChildren();
        }
        if (parentElement instanceof PackageFragmentRootContainer) {
            return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)parentElement, true);
        }
        if (parentElement instanceof IJavaScriptElement) {
            return this.jsContentProvider.getChildren(parentElement);
        }
        try {
            if (parentElement instanceof IMethod) {
                return NO_CHILDREN;
            }
            if (parentElement instanceof IScriptModel) {
                return StandardModelElementContentProvider.concatenate((Object[])this.getScriptProjects((IScriptModel)parentElement), (Object[])this.getNonPhpProjects((IScriptModel)parentElement));
            }
            if (parentElement instanceof ISourceModule || !(parentElement instanceof IOpenable) || parentElement instanceof ExternalProjectFragment) {
                if (parentElement instanceof IFolder) {
                    return ((IFolder)parentElement).members();
                }
                return super.getChildren(parentElement);
            }
            if (parentElement instanceof IOpenable) {
                if (parentElement instanceof ExternalScriptFolder) {
                    return super.getChildren(parentElement);
                }
                IResource resource = ((IOpenable)parentElement).getResource();
                if (resource instanceof IContainer) {
                    Object modelElement;
                    if (!resource.isAccessible()) {
                        return NO_CHILDREN;
                    }
                    ArrayList<Object> returnChlidren = new ArrayList<Object>();
                    boolean groupByNamespace = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("PHPExplorerPart.groupByNamespaces");
                    if (groupByNamespace && parentElement instanceof IScriptProject && this.supportsNamespaces((IScriptProject)parentElement)) {
                        returnChlidren.add(new GlobalNamespace((IScriptProject)parentElement));
                        returnChlidren.addAll(Arrays.asList(this.getAllNamespaces((IScriptProject)parentElement)));
                    } else {
                        IResource[] resChildren;
                        IResource[] iResourceArray = resChildren = ((IContainer)resource).members();
                        int n = resChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource resource2 = iResourceArray[n2];
                            modelElement = DLTKCore.create((IResource)resource2);
                            if (modelElement != null) {
                                returnChlidren.add(modelElement);
                            } else {
                                returnChlidren.add(resource2);
                            }
                            ++n2;
                        }
                    }
                    if (parentElement instanceof IScriptProject) {
                        Object[] projectChildren;
                        IScriptProject scriptProject = (IScriptProject)parentElement;
                        IProject project = scriptProject.getProject();
                        IncludePath[] includePaths = IncludePathManager.getInstance().getIncludePaths(project);
                        IncludePathContainer incPathContainer = new IncludePathContainer(scriptProject, includePaths);
                        returnChlidren.add((Object)incPathContainer);
                        Object[] objectArray = projectChildren = this.getProjectFragments(scriptProject);
                        int n = projectChildren.length;
                        int n3 = 0;
                        while (n3 < n) {
                            modelElement = objectArray[n3];
                            if (modelElement instanceof BuildPathContainer && ((BuildPathContainer)modelElement).getBuildpathEntry().getPath().equals((Object)LanguageModelInitializer.LANGUAGE_CONTAINER_PATH)) {
                                returnChlidren.add(modelElement);
                            }
                            ++n3;
                        }
                        boolean hasJsNature = JsNature.hasNature((IProject)project);
                        if (hasJsNature) {
                            ProjectLibraryRoot projectLibs = new ProjectLibraryRoot(JavaScriptCore.create((IProject)project));
                            returnChlidren.add(projectLibs);
                        }
                    }
                    return returnChlidren.toArray();
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return NO_CHILDREN;
    }

    protected boolean supportsNamespaces(IScriptProject project) {
        PHPVersion version = ProjectOptions.getPhpVersion((IProject)project.getProject());
        return version.isGreaterThan(PHPVersion.PHP5);
    }

    protected Object[] getAllNamespaces(IScriptProject project) throws ModelException {
        SearchEngine engine = new SearchEngine();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project, (int)1);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        SearchPattern pattern = SearchPattern.createPattern((String)"*", (int)0, (int)0, (int)2, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final HashMap processedNamespaces = new HashMap();
        try {
            engine.search(pattern, participants, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    Object element = match.getElement();
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        String elementName = type.getElementName();
                        if (PHPFlags.isNamespace((int)type.getFlags())) {
                            List<IType> result;
                            if (!processedNamespaces.containsKey(elementName)) {
                                result = new LinkedList();
                                processedNamespaces.put(elementName, result);
                            } else {
                                result = (List)processedNamespaces.get(elementName);
                            }
                            result.add(type);
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        LinkedList<NamespaceNode> result = new LinkedList<NamespaceNode>();
        for (String namespaceName : processedNamespaces.keySet()) {
            List list = (List)processedNamespaces.get(namespaceName);
            result.add(new NamespaceNode(project, namespaceName, list.toArray(new IType[list.size()])));
        }
        return result.toArray();
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container, boolean createFolder) {
        IAdaptable[] children = container.getChildren();
        if (children == null) {
            return new Object[0];
        }
        ArrayList<IJavaScriptElement> allChildren = new ArrayList<IJavaScriptElement>();
        ArrayList<Object> expanded = new ArrayList<Object>();
        expanded.addAll(Arrays.asList(children));
        if (expanded == null || expanded.size() < 1) {
            return new Object[0];
        }
        Object next = expanded.remove(0);
        while (next != null) {
            try {
                List<IJavaScriptElement> newChildren;
                if (next instanceof IPackageFragment) {
                    expanded.addAll(Arrays.asList(((IPackageFragment)next).getChildren()));
                } else if (next instanceof IPackageFragmentRoot) {
                    expanded.addAll(Arrays.asList(((IPackageFragmentRoot)next).getChildren()));
                } else if (next instanceof IClassFile) {
                    newChildren = Arrays.asList(((IClassFile)next).getChildren());
                    allChildren.removeAll(newChildren);
                    allChildren.addAll(newChildren);
                } else if (next instanceof IJavaScriptUnit) {
                    newChildren = Arrays.asList(((IJavaScriptUnit)next).getChildren());
                    allChildren.removeAll(newChildren);
                    allChildren.addAll(newChildren);
                }
            }
            catch (JavaScriptModelException ex) {
                Logger.logException(ex);
            }
            next = expanded.size() > 0 ? expanded.remove(0) : null;
        }
        return allChildren.toArray();
    }

    private Object[] getBuildPathEntryChildren(Object parentElement, Object entry) {
        IProjectFragment[] findProjectFragments;
        IScriptProject scriptProject = DLTKCore.create((IProject)((IncludePath)parentElement).getProject());
        IProjectFragment[] iProjectFragmentArray = findProjectFragments = scriptProject.findProjectFragments((IBuildpathEntry)entry);
        if (findProjectFragments.length != 0) {
            IProjectFragment projectFragment = iProjectFragmentArray[0];
            return this.getChildren(projectFragment);
        }
        return this.getChildren(((BuildpathEntry)entry).getPath());
    }

    public void refresh(IProject project) {
        ArrayList runnables = new ArrayList();
        ArrayList<IScriptProject> resources = new ArrayList<IScriptProject>(1);
        resources.add(DLTKCore.create((IProject)project));
        this.postRefresh(resources, true, runnables);
        this.executeRunnables(runnables);
    }

    protected class IncludePathContainer
    extends BuildPathContainer {
        private IncludePath[] fIncludePath;

        public IncludePathContainer(IScriptProject parent, IncludePath[] entries) {
            super(parent, DLTKCore.newContainerEntry((IPath)parent.getPath()));
            this.fIncludePath = entries;
        }

        public String getLabel() {
            return PHPUIMessages.getString("IncludePathExplorerNode_label");
        }

        public IAdaptable[] getChildren() {
            return this.fIncludePath;
        }
    }
}

