/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPVersionConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.wizards.IPHPProjectCreateWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPProjectWizardFirstPage
extends WizardPage
implements IPHPProjectCreateWizardPage {
    private static final String PAGE_NAME = NewWizardMessages.ScriptProjectWizardFirstPage_page_pageName;
    protected Validator fPdtValidator;
    protected String fInitialName;
    protected NameGroup fNameGroup;
    protected DetectGroup fDetectGroup;
    protected VersionGroup fVersionGroup;
    protected JavaScriptSupportGroup fJavaScriptSupportGroup;
    protected LayoutGroup fLayoutGroup;
    protected LocationGroup fPHPLocationGroup;

    public PHPProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.ScriptProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.ScriptProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fPHPLocationGroup = new LocationGroup(composite);
        this.fVersionGroup = new VersionGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fJavaScriptSupportGroup = new JavaScriptSupportGroup(composite, this);
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fPHPLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fPHPLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fPdtValidator = new Validator();
        this.fNameGroup.addObserver(this.fPdtValidator);
        this.fPHPLocationGroup.addObserver(this.fPdtValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.fNameGroup.postSetFocus();
        this.setHelpContext(composite);
    }

    protected void setHelpContext(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.creating_php_projects");
    }

    public URI getLocationURI() {
        IEnvironment environment = this.getEnvironment();
        return environment.getURI(this.fPHPLocationGroup.getLocation());
    }

    public IEnvironment getEnvironment() {
        return this.fPHPLocationGroup.getEnvironment();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean isInWorkspace() {
        return this.fPHPLocationGroup.isInWorkspace();
    }

    public boolean isInLocalServer() {
        return this.fPHPLocationGroup.isInLocalServer();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean hasPhpSourceFolder() {
        return this.fLayoutGroup != null && this.fLayoutGroup.isDetailedLayout();
    }

    public GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (!visible && currentPage != null && currentPage instanceof IPHPProjectCreateWizardPage) {
            ((IPHPProjectCreateWizardPage)currentPage).initPage();
        }
    }

    public void initPage() {
    }

    protected final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private Label fIcon;
        private boolean fDetect;

        public DetectGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.fIcon = new Label(composite, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fIcon.setVisible(false);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = PHPProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = PHPProjectWizardFirstPage.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
        }

        private boolean isValidProjectName(String name) {
            if (name.length() == 0) {
                return false;
            }
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            return workspace.validateName(name, 4).isOK() && workspace.getRoot().findMember(name) == null;
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                IPath location = PHPProjectWizardFirstPage.this.fPHPLocationGroup.getLocation();
                if (PHPProjectWizardFirstPage.this.fPHPLocationGroup.isInWorkspace()) {
                    if (!this.isValidProjectName(PHPProjectWizardFirstPage.this.getProjectName())) {
                        this.fDetect = false;
                    } else {
                        IEnvironment environment = PHPProjectWizardFirstPage.this.fPHPLocationGroup.getEnvironment();
                        IFileHandle directory = environment.getFile(location.append(PHPProjectWizardFirstPage.this.getProjectName()));
                        this.fDetect = directory.isDirectory();
                    }
                } else {
                    IEnvironment environment = PHPProjectWizardFirstPage.this.fPHPLocationGroup.getEnvironment();
                    if (location.toPortableString().length() > 0) {
                        IFileHandle directory = environment.getFile(location);
                        this.fDetect = directory.isDirectory();
                    }
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.ScriptProjectWizardFirstPage_DetectGroup_message);
                    } else {
                        this.fHintText.setVisible(false);
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (DLTKCore.DEBUG) {
                System.err.println("DetectGroup show compilancePreferencePage...");
            }
        }
    }

    public class JavaScriptSupportGroup
    implements SelectionListener {
        private final Group fGroup;
        protected Button fEnableJavaScriptSupport;

        public boolean shouldSupportJavaScript() {
            return PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.php.ui.wizards.JSsupport");
        }

        public JavaScriptSupportGroup(Composite composite, WizardPage projectWizardFirstPage) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(PHPUIMessages.getString("JavaScriptSupportGroup_OptionBlockTitle"));
            this.fEnableJavaScriptSupport = new Button((Composite)this.fGroup, 131104);
            this.fEnableJavaScriptSupport.setText(PHPUIMessages.getString("JavaScriptSupportGroup_EnableSupport"));
            this.fEnableJavaScriptSupport.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.fEnableJavaScriptSupport.addSelectionListener((SelectionListener)this);
            this.fEnableJavaScriptSupport.setSelection(PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.php.ui.wizards.JSsupport"));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PHPUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.php.ui.wizards.JSsupport", this.fEnableJavaScriptSupport.getSelection());
        }
    }

    public class LayoutGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private final SelectionButtonDialogField fStdRadio = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fSrcBinRadio;
        private Group fGroup;
        private Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fStdRadio.setLabelText(PHPUIMessages.getString("LayoutGroup_OptionBlock_ProjectSrc"));
            this.fStdRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(PHPUIMessages.getString("LayoutGroup_OptionBlock_SrcResources"));
            this.fSrcBinRadio.setDialogFieldListener((IDialogFieldListener)this);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.php.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(PHPUIMessages.getString("LayoutGroup_OptionBlock_Title"));
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(PHPUIMessages.getString("ToggleLinkingAction_link_description"));
            this.fPreferenceLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fPreferenceLink.setEnabled(true);
            this.updateEnableState();
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            if (PHPProjectWizardFirstPage.this.fDetectGroup == null) {
                return;
            }
            boolean detect = PHPProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!detect);
            }
        }

        public boolean isDetailedLayout() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String prefID = "org.eclipse.php.ui.preferences.PHPProjectLayoutPreferencePage";
            Object data = null;
            PreferencesUtil.createPreferenceDialogOn((Shell)PHPProjectWizardFirstPage.this.getShell(), (String)prefID, (String[])new String[]{prefID}, data).open();
        }
    }

    public class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private IEnvironment[] environments;
        private String fPreviousExternalLocation;
        private int localEnv;
        protected SelectionButtonDialogField fLocalServerRadio;
        protected ComboDialogField fSeverLocationList;
        private String[] docRootArray;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fExternalRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField((IStringButtonAdapter)this);
            this.fLocation.setDialogFieldListener((IDialogFieldListener)this);
            this.fLocation.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
            this.fExternalRadio.attachDialogFields(new DialogField[]{this.fLocation});
            this.environments = EnvironmentManager.getEnvironments();
            String[] items = new String[this.environments.length];
            this.localEnv = 0;
            int i = 0;
            while (i < items.length) {
                items[i] = this.environments[i].getName();
                if (this.environments[i].isLocal()) {
                    this.localEnv = i;
                }
                ++i;
            }
            Server[] servers = ServersManager.getServers();
            ArrayList<String> docRoots = new ArrayList<String>();
            int i2 = 0;
            while (i2 < servers.length) {
                String docRoot = servers[i2].getDocumentRoot();
                String isLocal = servers[i2].getAttribute("localserver", null);
                if (isLocal != null && docRoot != null && !"".equals(docRoot.trim())) {
                    docRoots.add(docRoot);
                }
                ++i2;
            }
            if (docRoots.size() > 0) {
                this.fLocalServerRadio = new SelectionButtonDialogField(16);
                this.fLocalServerRadio.setDialogFieldListener((IDialogFieldListener)this);
                this.fLocalServerRadio.setLabelText(PHPUIMessages.getString("PHPProjectWizardFirstPage.localServerLabel"));
                this.fLocalServerRadio.setSelection(false);
                this.fLocalServerRadio.doFillIntoGrid((Composite)group, 3);
                this.fSeverLocationList = new ComboDialogField(8);
                this.fSeverLocationList.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
                this.fSeverLocationList.doFillIntoGrid((Composite)group, 3);
                this.fSeverLocationList.setEnabled(false);
                this.docRootArray = new String[docRoots.size()];
                docRoots.toArray(this.docRootArray);
                this.fSeverLocationList.setItems(this.docRootArray);
                this.fSeverLocationList.selectItem(0);
                this.fLocalServerRadio.attachDialogField((DialogField)this.fSeverLocationList);
                this.fWorkspaceRadio.setSelection(false);
                this.fLocalServerRadio.setSelection(true);
            }
        }

        public boolean isInLocalServer() {
            return this.fLocalServerRadio != null && this.fLocalServerRadio.isSelected();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IEnvironment environment = this.getEnvironment();
            if (environment != null && environment.isLocal()) {
                IPath path = Platform.getLocation().append(name);
                return path.toOSString();
            }
            return "";
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(PHPProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            if (this.docRootArray != null && this.docRootArray.length > 0) {
                int index = this.fSeverLocationList.getSelectionIndex();
                String[] items = this.getDocItems(this.docRootArray);
                this.fSeverLocationList.setItems(items);
                this.fSeverLocationList.selectItem(index);
            }
            this.fireEvent();
        }

        private String[] getDocItems(String[] docRootArray) {
            String[] items = new String[docRootArray.length];
            int i = 0;
            while (i < docRootArray.length) {
                items[i] = String.valueOf(docRootArray[i]) + File.separator + PHPProjectWizardFirstPage.this.fNameGroup.getName();
                ++i;
            }
            return items;
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            if (this.isInLocalServer()) {
                return new Path(this.fSeverLocationList.getText());
            }
            return new Path(this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public IEnvironment getEnvironment() {
            if (this.fWorkspaceRadio.isSelected()) {
                return EnvironmentManager.getEnvironmentById((String)"org.eclipse.dltk.core.environment.localEnvironment");
            }
            return this.environments[this.localEnv];
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            IEnvironment environment = this.getEnvironment();
            IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
            if (environmentUI != null && (selectedDirectory = environmentUI.selectFolder(PHPProjectWizardFirstPage.this.getShell())) != null) {
                this.fLocation.setText(selectedDirectory);
                DLTKUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(PHPProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    IEnvironment environment = this.getEnvironment();
                    if (environment != null && environment.isLocal()) {
                        this.fLocation.setText(this.fPreviousExternalLocation);
                    } else {
                        this.fLocation.setText("");
                    }
                }
            }
            this.fireEvent();
        }
    }

    public final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener((IDialogFieldListener)this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(PHPProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    public final class Validator
    implements Observer {
        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IEnvironment environment;
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            String name = PHPProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                PHPProjectWizardFirstPage.this.setErrorMessage(null);
                PHPProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                PHPProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = PHPProjectWizardFirstPage.this.getProjectHandle();
            if (!PHPProjectWizardFirstPage.this.isInLocalServer() && handle.exists()) {
                PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = PHPProjectWizardFirstPage.this.fPHPLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                PHPProjectWizardFirstPage.this.setErrorMessage(null);
                PHPProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!PHPProjectWizardFirstPage.this.fPHPLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                PHPProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace);
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!PHPProjectWizardFirstPage.this.fPHPLocationGroup.isInWorkspace() && EnvironmentManager.isLocal((IEnvironment)(environment = PHPProjectWizardFirstPage.this.getEnvironment())) && !(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                PHPProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                PHPProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            PHPProjectWizardFirstPage.this.setPageComplete(true);
            PHPProjectWizardFirstPage.this.setErrorMessage(null);
            PHPProjectWizardFirstPage.this.setMessage(null);
        }
    }

    public class VersionGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener,
    SelectionListener {
        protected final SelectionButtonDialogField fDefaultValues;
        protected final SelectionButtonDialogField fCustomValues;
        protected PHPVersionConfigurationBlock fConfigurationBlock;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";
        private Link fPreferenceLink;

        public VersionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)PHPProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(PHPUIMessages.getString("VersionGroup_OptionBlock_Title"));
            this.fDefaultValues = new SelectionButtonDialogField(16);
            this.fDefaultValues.setDialogFieldListener((IDialogFieldListener)this);
            this.fDefaultValues.setLabelText(PHPUIMessages.getString("VersionGroup_OptionBlock_fDefaultValues"));
            this.fCustomValues = new SelectionButtonDialogField(16);
            this.fCustomValues.setDialogFieldListener((IDialogFieldListener)this);
            this.fCustomValues.setLabelText(PHPUIMessages.getString("VersionGroup_OptionBlock_fCustomValues"));
            this.fDefaultValues.setSelection(true);
            this.fCustomValues.setSelection(false);
            this.fDefaultValues.doFillIntoGrid((Composite)group, 3);
            this.fCustomValues.doFillIntoGrid((Composite)group, 3);
            this.fConfigurationBlock = this.createConfigurationBlock(new IStatusChangeListener(){

                public void statusChanged(IStatus status) {
                }
            }, null, null);
            this.fConfigurationBlock.createContents((Composite)group);
            this.fConfigurationBlock.setEnabled(false);
        }

        protected PHPVersionConfigurationBlock createConfigurationBlock(IStatusChangeListener listener, IProject project, IWorkbenchPreferenceContainer container) {
            return new PHPVersionConfigurationBlock(listener, project, container);
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public void update(Observable o, Object arg) {
            this.fireEvent();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            IEnvironment environment = PHPProjectWizardFirstPage.this.getEnvironment();
            IEnvironmentUI environmentUI = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class);
            if (environmentUI != null && (selectedDirectory = environmentUI.selectFolder(PHPProjectWizardFirstPage.this.getShell())) != null) {
                DLTKUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fDefaultValues) {
                boolean checked = this.fDefaultValues.isSelected();
                if (this.fConfigurationBlock != null) {
                    this.fConfigurationBlock.setEnabled(!checked);
                }
            }
            this.fireEvent();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String prefID = "org.eclipse.php.ui.preferences.PHPInterpreterPreferencePage";
            Object data = null;
            PreferencesUtil.createPreferenceDialogOn((Shell)PHPProjectWizardFirstPage.this.getShell(), (String)prefID, (String[])new String[]{prefID}, data).open();
            if (!this.fCustomValues.isSelected()) {
                this.fConfigurationBlock.performRevert();
            }
        }
    }
}

