/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;

public abstract class AbstractOccurrencesFinder
extends AbstractVisitor
implements IOccurrencesFinder {
    protected static final String BASE_DESCRIPTION = PHPUIMessages.getString("AbstractOccurrencesFinder.0");
    protected static final String BASE_WRITE_DESCRIPTION = PHPUIMessages.getString("AbstractOccurrencesFinder.1");
    protected static final String BRACKETS = "()";
    protected List<IOccurrencesFinder.OccurrenceLocation> fResult;
    protected String fDescription;
    protected Program fASTRoot;
    protected ProblemDesc[] fProblems;

    public String initialize(Program root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        this.findOccurrences();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    public static ProblemDesc[] getProblems(Program node) {
        block5: {
            if (node.getSourceModule() != null) break block5;
            return null;
        }
        try {
            IResource resource = node.getSourceModule().getUnderlyingResource();
            if (resource != null) {
                IMarker[] markers = resource.findMarkers("org.eclipse.dltk.core.problem", true, 1);
                ProblemDesc[] problems = new ProblemDesc[markers.length];
                int i = 0;
                while (i < markers.length) {
                    problems[i] = new ProblemDesc(markers[i].getAttribute("id", 0), markers[i].getAttribute("charStart", 0), markers[i].getAttribute("charEnd", 0), markers[i].getAttribute("severity", 0));
                    ++i;
                }
                return problems;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected boolean hasProblems(int offset, int end) {
        if (this.fProblems != null) {
            ProblemDesc[] problemDescArray = this.fProblems;
            int n = this.fProblems.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemDesc problemDesc = problemDescArray[n2];
                if (problemDesc.offset <= offset && problemDesc.end >= end) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void addOccurrence(IOccurrencesFinder.OccurrenceLocation location) {
        if (!this.hasProblems(location.getOffset(), location.getOffset() + location.getLength())) {
            this.fResult.add(location);
        }
    }

    protected abstract void findOccurrences();

    protected abstract int getOccurrenceType(ASTNode var1);

    public Program getASTRoot() {
        return this.fASTRoot;
    }

    public String getJobLabel() {
        return "OccurrencesFinder_job_label";
    }

    public int getSearchKind() {
        return 5;
    }

    public String getUnformattedPluralLabel() {
        return "OccurrencesFinder_label_plural";
    }

    public String getUnformattedSingularLabel() {
        return "OccurrencesFinder_label_singular";
    }

    static class ProblemDesc {
        int kind;
        int offset;
        int end;
        int severity;

        public ProblemDesc(int kind, int offset, int end, int severity) {
            this.kind = kind;
            this.offset = offset;
            this.end = end;
            this.severity = severity;
        }

        public boolean isError() {
            return (this.severity & 1) != 0;
        }
    }
}

