/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.core.util.ProjectBackwardCompatibilityUtil;
import org.osgi.framework.BundleContext;

public class PHPCorePlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.core";
    public static final int INTERNAL_ERROR = 10001;
    private static PHPCorePlugin plugin;
    public static transient boolean toolkitInitialized;
    private final ListenerList shutdownListeners = new ListenerList();
    private ProjectConversionListener projectConvertListener = new ProjectConversionListener();
    private ReindexOperationListener reindexOperationListener = new ReindexOperationListener();
    public static final boolean isDebugMode;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.php.core/debug");
        isDebugMode = value != null && value.equalsIgnoreCase("true");
    }

    public PHPCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeAfterStart();
    }

    void initializeAfterStart() {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                IncludePathManager.getInstance();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)PHPCorePlugin.this.projectConvertListener, 8);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)PHPCorePlugin.this.reindexOperationListener, 8);
                try {
                    PHPCorePlugin.this.convertProjects();
                }
                catch (CoreException e) {
                    PHPCorePlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(30L);
    }

    private void convertProjects() throws CoreException, ModelException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.processProjects(projects);
    }

    private void processProjects(IProject[] projects) throws CoreException, ModelException {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && PHPToolkitUtil.isPhpProject(project)) {
                    IProjectDescription projectDescription = project.getDescription();
                    ICommand[] commands = projectDescription.getBuildSpec();
                    int i = 0;
                    while (i < commands.length) {
                        if (!commands[i].getBuilderName().equals("org.eclipse.dltk.core.scriptbuilder")) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    this.modifyProject(project);
                }
            }
            ++n2;
        }
    }

    private void modifyProject(IProject project) throws CoreException, ModelException {
        ProjectBackwardCompatibilityUtil unit;
        IBuildpathEntry[] oldIncludePath;
        PHPNature phpNature = new PHPNature();
        phpNature.setProject(project);
        phpNature.configure();
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IBuildpathEntry[] existingPath = scriptProject.getRawBuildpath();
        ArrayList<IBuildpathEntry> newPath = new ArrayList<IBuildpathEntry>();
        if (existingPath != null) {
            newPath.addAll(Arrays.asList(existingPath));
        }
        if ((oldIncludePath = (unit = new ProjectBackwardCompatibilityUtil()).convertIncludePathForProject(project)) != null) {
            newPath.addAll(Arrays.asList(oldIncludePath));
        }
        scriptProject.setRawBuildpath(newPath.toArray(new IBuildpathEntry[newPath.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    public void addShutdownListener(IShutdownListener listener) {
        this.shutdownListeners.add((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        Object[] listeners = this.shutdownListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IShutdownListener)listeners[i]).shutdown();
            ++i;
        }
        this.shutdownListeners.clear();
        super.stop(context);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.projectConvertListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.reindexOperationListener);
        plugin = null;
    }

    public static PHPCorePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        PHPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PHPCorePlugin.log((IStatus)new Status(4, ID, 10001, "PHPCore plugin internal error", e));
    }

    public static void logErrorMessage(String message) {
        PHPCorePlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }

    public static String getPluginId() {
        return ID;
    }

    public static String getOption(String optionName) {
        return ModelManager.getModelManager().getOption(optionName);
    }

    public static Hashtable getOptions() {
        return ModelManager.getModelManager().getOptions();
    }

    public static void initializeAfterLoad(IProgressMonitor monitor) throws CoreException {
        try {
            if (monitor != null) {
                monitor.beginTask(CoreMessages.PHPCorePlugin_initializingPHPToolkit, 125);
            }
            IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            try {
                if (monitor != null) {
                    monitor.subTask(CoreMessages.PHPCorePlugin_initializingSearchEngine);
                    monitor.worked(25);
                }
                PhpModelAccess.getDefault().findMethods("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, monitor);
                if (monitor != null) {
                    monitor.worked(25);
                }
                PhpModelAccess.getDefault().findTypes("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, monitor);
                if (monitor != null) {
                    monitor.worked(25);
                }
                PhpModelAccess.getDefault().findFields("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, monitor);
                if (monitor != null) {
                    monitor.worked(25);
                }
                PhpModelAccess.getDefault().findIncludes("", ISearchEngine.MatchRule.PREFIX, scope, monitor);
                if (monitor != null) {
                    monitor.worked(25);
                }
            }
            catch (OperationCanceledException e) {
                if (monitor != null && monitor.isCanceled()) {
                    throw e;
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            toolkitInitialized = true;
        }
    }

    private class ProjectConversionListener
    implements IResourceChangeListener {
        private ProjectConversionListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] affectedChildren = delta.getAffectedChildren();
            IProject[] projects = new IProject[affectedChildren.length];
            int i = 0;
            while (i < affectedChildren.length) {
                projects[i] = affectedChildren[i].getResource().getProject();
                ++i;
            }
            try {
                PHPCorePlugin.this.processProjects(projects);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private class ReindexOperationListener
    implements IResourceChangeListener {
        private ReindexOperationListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getBuildKind() == 15) {
                Object source = event.getSource();
                try {
                    if (source instanceof IProject) {
                        IProject project = (IProject)source;
                        ProjectIndexerManager.removeProject((IPath)project.getFullPath());
                        ProjectIndexerManager.indexProject((IProject)project);
                    } else if (source instanceof IWorkspace) {
                        IProject project;
                        IProject[] projects;
                        IWorkspace workspace = (IWorkspace)source;
                        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
                        int n = projects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            project = iProjectArray[n2];
                            if (project.isAccessible()) {
                                IProjectFragment[] projectFragments;
                                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                                IProjectFragment[] iProjectFragmentArray = projectFragments = scriptProject.getProjectFragments();
                                int n3 = projectFragments.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IProjectFragment projectFragment = iProjectFragmentArray[n4];
                                    ProjectIndexerManager.removeProjectFragment((IScriptProject)scriptProject, (IPath)projectFragment.getPath());
                                    ++n4;
                                }
                                ProjectIndexerManager.removeProject((IPath)project.getFullPath());
                            }
                            ++n2;
                        }
                        iProjectArray = projects;
                        n = projects.length;
                        n2 = 0;
                        while (n2 < n) {
                            project = iProjectArray[n2];
                            if (project.isAccessible()) {
                                ProjectIndexerManager.indexProject((IProject)project);
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
    }
}

