/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassDeclarationKeywordContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class ClassDeclarationKeywordsStrategy
extends AbstractCompletionStrategy {
    public ClassDeclarationKeywordsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassDeclarationKeywordsStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ClassDeclarationKeywordContext)) {
            return;
        }
        ClassDeclarationKeywordContext concreteContext = (ClassDeclarationKeywordContext)context;
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        String prefix = concreteContext.getPrefix();
        if (CodeAssistUtils.startsWithIgnoreCase("extends", prefix)) {
            reporter.reportKeyword("extends", this.getSuffix(concreteContext), replaceRange);
        }
        if (CodeAssistUtils.startsWithIgnoreCase("implements", prefix) && concreteContext.getPhpVersion().isGreaterThan(PHPVersion.PHP4)) {
            reporter.reportKeyword("implements", this.getSuffix(concreteContext), replaceRange);
        }
    }

    public String getSuffix(AbstractCompletionContext context) {
        return context.hasWhitespaceBeforeCursor() ? " " : "";
    }
}

