/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.ClassMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMembersStrategy;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class ClassFieldsStrategy
extends ClassMembersStrategy {
    public ClassFieldsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassFieldsStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ClassMemberContext)) {
            return;
        }
        ClassMemberContext concreteContext = (ClassMemberContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        String prefix = concreteContext.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = concreteContext.getLhsTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(type, null);
                IField[] fields = PHPModelUtils.getTypeHierarchyField(type, hierarchy, prefix, requestor.isContextInformationMode(), null);
                for (IField field : this.removeOverriddenElements(Arrays.asList(fields))) {
                    if (this.isFiltered((IMember)field, concreteContext)) continue;
                    result.add(field);
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        for (IField field : result) {
            reporter.reportField(field, this.getSuffix(), replaceRange, concreteContext.getTriggerType() == ClassMemberContext.Trigger.OBJECT);
        }
    }

    protected boolean showNonStaticMembers(ClassMemberContext context) {
        return super.showNonStaticMembers(context) && !this.isParentCall(context);
    }

    public String getSuffix() {
        return "";
    }
}

