/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;
import org.eclipse.php.internal.core.typeinference.FakeMethod;

public class ClassInstantiationStrategy
extends GlobalTypesStrategy {
    public ClassInstantiationStrategy(ICompletionContext context) {
        super(context, 0, 2057);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IType[] types;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext concreteContext = (AbstractCompletionContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        IType enclosingClass = null;
        try {
            IModelElement parent;
            IModelElement enclosingElement = concreteContext.getSourceModule().getElementAt(concreteContext.getOffset());
            while (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IMethod && (parent = ((IMethod)enclosingElement).getParent()) instanceof IType) {
                enclosingClass = (IType)parent;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        SourceRange replaceRange = this.getReplacementRange(context);
        String suffix = this.getSuffix(concreteContext);
        IType[] iTypeArray = types = this.getTypes(concreteContext);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IMethod ctor = null;
            if (requestor.isContextInformationMode()) {
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n3 = iMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod method = iMethodArray[n4];
                        if (method.isConstructor()) {
                            ctor = method;
                            break;
                        }
                        ++n4;
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
            try {
                if (ctor != null) {
                    if (!PHPFlags.isPrivate((int)ctor.getFlags()) || type.equals(enclosingClass)) {
                        ISourceRange sourceRange = type.getSourceRange();
                        FakeMethod ctorMethod = new FakeMethod((ModelElement)type, type.getElementName(), sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()){

                            public boolean isConstructor() throws ModelException {
                                return true;
                            }
                        };
                        ctorMethod.setParameters(ctor.getParameters());
                        reporter.reportMethod((IMethod)ctorMethod, suffix, replaceRange);
                    }
                } else {
                    reporter.reportType(type, suffix, replaceRange);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        this.addSelf(concreteContext, reporter);
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "(".equals(nextWord) ? "" : "()";
    }
}

