/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.ISourceParserFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.php5.PhpSourceParser;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class PHPSourceParserFactory
extends AbstractSourceParser
implements ISourceParserFactory,
ISourceParser {
    public ISourceParser createSourceParser() {
        return this;
    }

    public ModuleDeclaration parse(char[] fileName, char[] source, IProblemReporter reporter) {
        AbstractPHPSourceParser parser = this.createParser(new String(fileName));
        return parser.parse(fileName, source, reporter);
    }

    protected AbstractPHPSourceParser createParser(String fileName) {
        PHPVersion phpVersion = ProjectOptions.getPhpVersion(fileName);
        AbstractPHPSourceParser parser = PHPSourceParserFactory.createParser(fileName, phpVersion);
        if (parser == null) {
            throw new IllegalStateException("Unknown PHP version!");
        }
        return parser;
    }

    public static AbstractPHPSourceParser createParser(String fileName, PHPVersion phpVersion) {
        if (PHPVersion.PHP4 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php4.PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5 == phpVersion) {
            return new PhpSourceParser(fileName);
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php53.PhpSourceParser(fileName);
        }
        return null;
    }

    public static AbstractPHPSourceParser createParser(PHPVersion phpVersion) {
        if (PHPVersion.PHP4 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php4.PhpSourceParser();
        }
        if (PHPVersion.PHP5 == phpVersion) {
            return new PhpSourceParser();
        }
        if (PHPVersion.PHP5_3 == phpVersion) {
            return new org.eclipse.php.internal.core.compiler.ast.parser.php53.PhpSourceParser();
        }
        return null;
    }
}

