/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.php.core.language.ILanguageModelProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;

public class LanguageModelContainer
implements IBuildpathContainer {
    private IPath containerPath;
    private IBuildpathEntry[] buildPathEntries;

    public LanguageModelContainer(IPath containerPath) {
        this.containerPath = containerPath;
    }

    public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
        if (this.buildPathEntries == null) {
            try {
                LinkedList<IBuildpathEntry> entries = new LinkedList<IBuildpathEntry>();
                ILanguageModelProvider[] iLanguageModelProviderArray = LanguageModelInitializer.getContributedProviders();
                int n = iLanguageModelProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILanguageModelProvider provider = iLanguageModelProviderArray[n2];
                    IPath path = provider.getPath(project);
                    if (path != null) {
                        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
                        if (environment != null) {
                            path = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)path);
                        }
                        entries.add(DLTKCore.newLibraryEntry((IPath)path, (IAccessRule[])BuildpathEntry.NO_ACCESS_RULES, (IBuildpathAttribute[])BuildpathEntry.NO_EXTRA_ATTRIBUTES, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (boolean)false, (boolean)true));
                    }
                    ++n2;
                }
                this.buildPathEntries = entries.toArray(new IBuildpathEntry[entries.size()]);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return this.buildPathEntries;
    }

    public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
        return null;
    }

    public String getDescription(IScriptProject project) {
        return "PHP Language Library";
    }

    public int getKind() {
        return 2;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public IBuildpathEntry[] getRawBuildpathEntries(IScriptProject project) {
        return this.getBuildpathEntries(project);
    }
}

