/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.internal.core.typeinference.context.ContextFinder;

public class VariableDeclarationSearcher
extends ContextFinder {
    private Map<IContext, DeclarationScope> scopes = new HashMap<IContext, DeclarationScope>();
    protected Stack<ASTNode> nodesStack = new Stack();

    public VariableDeclarationSearcher(ISourceModule sourceModule) {
        super(sourceModule);
    }

    protected void postProcess(ModuleDeclaration node) {
    }

    public final boolean visit(ModuleDeclaration node) throws Exception {
        if (!this.isInteresting((ASTNode)node)) {
            this.visitGeneral((ASTNode)node);
            return false;
        }
        this.postProcess(node);
        return super.visit(node);
    }

    public final boolean endvisit(ModuleDeclaration node) throws Exception {
        return super.endvisit(node);
    }

    protected void postProcess(TypeDeclaration node) {
    }

    public final boolean visit(TypeDeclaration node) throws Exception {
        if (!this.isInteresting((ASTNode)node)) {
            this.visitGeneral((ASTNode)node);
            return false;
        }
        this.postProcess(node);
        return super.visit(node);
    }

    public final boolean endvisit(TypeDeclaration node) throws Exception {
        return super.endvisit(node);
    }

    protected void postProcess(MethodDeclaration node) {
    }

    public final boolean visit(MethodDeclaration node) throws Exception {
        if (!this.isInteresting((ASTNode)node)) {
            this.visitGeneral((ASTNode)node);
            return false;
        }
        this.postProcess(node);
        return super.visit(node);
    }

    public final boolean endvisit(MethodDeclaration node) throws Exception {
        return super.endvisit(node);
    }

    protected void postProcess(Expression node) {
    }

    public final boolean visit(Expression node) throws Exception {
        if (!this.isInteresting((ASTNode)node)) {
            this.visitGeneral((ASTNode)node);
            return false;
        }
        ASTNode parent = this.nodesStack.peek();
        if (this.isConditional(parent)) {
            this.getScope().enterInnerBlock((Statement)parent);
        }
        if (node instanceof Assignment) {
            Expression variable = ((Assignment)node).getVariable();
            this.addDeclaredVariables(variable, node);
        }
        this.postProcess(node);
        return super.visit(node);
    }

    private void addDeclaredVariables(Expression variable, Expression node) {
        if (variable instanceof VariableReference) {
            VariableReference varReference = (VariableReference)variable;
            this.getScope().addDeclaration(varReference.getName(), (ASTNode)node);
        } else if (variable instanceof ListVariable) {
            ListVariable varReference = (ListVariable)variable;
            for (Expression expression : varReference.getVariables()) {
                this.addDeclaredVariables(expression, node);
            }
        }
    }

    public final boolean endvisit(Expression node) throws Exception {
        return super.endvisit(node);
    }

    protected void postProcess(Statement node) {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean visit(Statement node) throws Exception {
        if (!this.isInteresting((ASTNode)node)) {
            this.visitGeneral((ASTNode)node);
            return false;
        }
        ASTNode parent = this.nodesStack.peek();
        if (this.isConditional(parent)) {
            this.getScope().enterInnerBlock((Statement)parent);
        }
        if (node instanceof GlobalStatement) {
            GlobalStatement globalStatement = (GlobalStatement)node;
            for (Expression expression : globalStatement.getVariables()) {
                if (!(expression instanceof VariableReference)) continue;
                VariableReference varReference = (VariableReference)expression;
                this.getScope().addDeclaration(varReference.getName(), (ASTNode)globalStatement);
            }
        } else if (node instanceof FormalParameter) {
            FormalParameter parameter = (FormalParameter)node;
            this.getScope().addDeclaration(parameter.getName(), (ASTNode)parameter);
        } else if (node instanceof CatchClause) {
            CatchClause clause = (CatchClause)node;
            VariableReference variableReference = clause.getVariable();
            this.getScope().addDeclaration(variableReference.getName(), (ASTNode)clause);
        } else if (node instanceof ForEachStatement) {
            Expression key;
            void var4_13;
            ForEachStatement foreachStatement = (ForEachStatement)node;
            Expression expression = foreachStatement.getValue();
            if (expression instanceof ReferenceExpression) {
                Expression expression2 = ((ReferenceExpression)expression).getVariable();
            }
            if (var4_13 instanceof SimpleReference) {
                String variableName = ((SimpleReference)var4_13).getName();
                this.getScope().addDeclaration(variableName, (ASTNode)foreachStatement);
            }
            if ((key = foreachStatement.getKey()) instanceof SimpleReference) {
                String variableName = ((SimpleReference)key).getName();
                this.getScope().addDeclaration(variableName, (ASTNode)foreachStatement);
            }
        }
        this.postProcess(node);
        return super.visit(node);
    }

    public final boolean endvisit(Statement node) throws Exception {
        if (this.isConditional((ASTNode)node)) {
            this.getScope().exitInnerBlock();
        }
        return super.endvisit(node);
    }

    protected void postProcessGeneral(ASTNode node) {
    }

    public final boolean visitGeneral(ASTNode node) throws Exception {
        this.nodesStack.push(node);
        this.postProcessGeneral(node);
        return super.visitGeneral(node);
    }

    public final void endvisitGeneral(ASTNode node) throws Exception {
        this.nodesStack.pop();
        super.endvisitGeneral(node);
    }

    protected boolean isInteresting(ASTNode node) {
        return true;
    }

    protected boolean isConditional(ASTNode node) {
        if (node instanceof Statement) {
            int kind = ((Statement)node).getKind();
            return kind == 9 || kind == 34 || kind == 28 || kind == 26 || kind == 55 || kind == 61;
        }
        return false;
    }

    protected DeclarationScope getScope() {
        return this.getScope((IContext)this.contextStack.peek());
    }

    protected DeclarationScope getScope(IContext context) {
        if (!this.scopes.containsKey(context)) {
            this.scopes.put(context, new DeclarationScope(context));
        }
        return this.scopes.get(context);
    }

    public DeclarationScope[] getScopes() {
        Collection<DeclarationScope> values = this.scopes.values();
        return values.toArray(new DeclarationScope[values.size()]);
    }

    public Declaration[] getDeclarations(String varName, IContext context) {
        return this.getScope(context).getDeclarations(varName);
    }

    public class Declaration {
        private boolean global;
        private ASTNode declNode;

        public Declaration(boolean global, ASTNode declNode) {
            this.global = global;
            this.declNode = declNode;
        }

        public boolean isGlobal() {
            return this.global;
        }

        public void setGlobal(boolean global) {
            this.global = global;
        }

        public ASTNode getNode() {
            return this.declNode;
        }

        public void setNode(ASTNode declNode) {
            this.declNode = declNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeclarationScope {
        private Map<String, LinkedList<Declaration>> decls = new HashMap<String, LinkedList<Declaration>>();
        private IContext context;
        private Stack<Statement> innerBlocks = new Stack();

        public DeclarationScope(IContext context) {
            this.context = context;
        }

        public IContext getContext() {
            return this.context;
        }

        public void enterInnerBlock(Statement s) {
            if (!this.innerBlocks.isEmpty() && this.innerBlocks.peek() == s) {
                return;
            }
            this.innerBlocks.push(s);
        }

        public void exitInnerBlock() {
            if (!this.innerBlocks.isEmpty()) {
                this.innerBlocks.pop();
            }
        }

        public int getInnerBlockLevel() {
            return this.innerBlocks.size();
        }

        public Map<String, LinkedList<Declaration>> getAllDeclarations() {
            return this.decls;
        }

        public Declaration[] getDeclarations(String varName) {
            LinkedList<Declaration> result = new LinkedList<Declaration>();
            LinkedList<Declaration> varDecls = this.decls.get(varName);
            if (varDecls != null) {
                for (Declaration decl : varDecls) {
                    if (decl == null) continue;
                    result.add(decl);
                }
            }
            return result.toArray(new Declaration[result.size()]);
        }

        public void addDeclaration(String varName, ASTNode declNode) {
            Declaration decl;
            LinkedList<Declaration> varDecls = this.decls.get(varName);
            if (varDecls == null) {
                varDecls = new LinkedList();
                this.decls.put(varName, varDecls);
            }
            int level = this.innerBlocks.size();
            while (varDecls.size() > level + 1) {
                varDecls.removeLast();
            }
            while (varDecls.size() < level) {
                varDecls.addLast(null);
            }
            if (varDecls.size() > level && (decl = varDecls.get(level)) != null) {
                decl.setNode(declNode);
                return;
            }
            varDecls.addLast(new Declaration(declNode instanceof GlobalStatement, declNode));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Variable Declarations (").append(this.context).append("): \n\n");
            for (String varName : this.decls.keySet()) {
                buf.append(varName).append(" => { \n\n");
                LinkedList<Declaration> varDecls = this.decls.get(varName);
                if (varDecls != null) {
                    for (Declaration declNode : varDecls) {
                        buf.append(declNode.toString()).append(", \n\n");
                    }
                }
                buf.append("}, \n\n");
            }
            return buf.toString();
        }
    }
}

