/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.VariableDeclarationSearcher;
import org.eclipse.php.internal.core.typeinference.goals.GlobalVariableReferencesGoal;

public class GlobalVariableReferencesEvaluator
extends GoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public GlobalVariableReferencesEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        GlobalVariableReferencesGoal typedGoal = (GlobalVariableReferencesGoal)this.goal;
        IContext context = this.goal.getContext();
        ISourceModuleContext sourceModuleContext = null;
        if (context instanceof ISourceModuleContext) {
            sourceModuleContext = (ISourceModuleContext)context;
        }
        String variableName = typedGoal.getVariableName();
        boolean exploreOtherFiles = true;
        IScriptProject scriptProject = sourceModuleContext.getSourceModule().getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        IField[] elements = PhpModelAccess.getDefault().findFields(variableName, ISearchEngine.MatchRule.EXACT, 8192, 2, scope, null);
        HashMap<ISourceModule, TreeSet<ISourceRange>> offsets = new HashMap<ISourceModule, TreeSet<ISourceRange>>();
        Comparator<ISourceRange> sourceRangeComparator = new Comparator<ISourceRange>(){

            @Override
            public int compare(ISourceRange o1, ISourceRange o2) {
                return o1.getOffset() - o2.getOffset();
            }
        };
        IField[] iFieldArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IField element = iFieldArray[n2];
                if (element instanceof SourceField) {
                    SourceField sourceField = (SourceField)element;
                    ISourceModule sourceModule = sourceField.getSourceModule();
                    if (!offsets.containsKey(sourceModule)) {
                        offsets.put(sourceModule, new TreeSet<ISourceRange>(sourceRangeComparator));
                    }
                    try {
                        ((SortedSet)offsets.get(sourceModule)).add(sourceField.getSourceRange());
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block11;
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        LinkedList<ExpressionTypeGoal> subGoals = new LinkedList<ExpressionTypeGoal>();
        for (ISourceModule sourceModule : offsets.keySet()) {
            if (!exploreOtherFiles && (sourceModuleContext == null || !sourceModuleContext.getSourceModule().equals(sourceModule))) continue;
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            SortedSet fileOffsets = (SortedSet)offsets.get(sourceModule);
            if (fileOffsets.isEmpty()) continue;
            GlobalReferenceDeclSearcher varSearcher = new GlobalReferenceDeclSearcher(sourceModule, fileOffsets, variableName);
            try {
                VariableDeclarationSearcher.DeclarationScope[] scopes;
                moduleDeclaration.traverse((ASTVisitor)varSearcher);
                VariableDeclarationSearcher.DeclarationScope[] declarationScopeArray = scopes = varSearcher.getScopes();
                int n3 = scopes.length;
                int n4 = 0;
                while (n4 < n3) {
                    VariableDeclarationSearcher.DeclarationScope s = declarationScopeArray[n4];
                    VariableDeclarationSearcher.Declaration[] declarationArray = s.getDeclarations(variableName);
                    int n5 = declarationArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        VariableDeclarationSearcher.Declaration decl = declarationArray[n6];
                        subGoals.add(new ExpressionTypeGoal(s.getContext(), decl.getNode()));
                        ++n6;
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GlobalReferenceDeclSearcher
    extends VariableDeclarationSearcher {
        private final String variableName;
        private Iterator<ISourceRange> offsetsIt;
        private int currentStart;
        private int currentEnd;
        private boolean stopProcessing;

        public GlobalReferenceDeclSearcher(ISourceModule sourceModule, SortedSet<ISourceRange> offsets, String variableName) {
            super(sourceModule);
            this.variableName = variableName;
            this.offsetsIt = offsets.iterator();
            this.setNextRange();
        }

        private void setNextRange() {
            if (this.offsetsIt.hasNext()) {
                ISourceRange range = this.offsetsIt.next();
                this.currentStart = range.getOffset();
                this.currentEnd = this.currentStart + range.getLength();
            } else {
                this.stopProcessing = true;
            }
        }

        @Override
        protected void postProcess(Expression node) {
            VariableReference variableReference;
            Expression variable;
            if (node instanceof Assignment && (variable = ((Assignment)node).getVariable()) instanceof VariableReference && this.variableName.equals((variableReference = (VariableReference)variable).getName())) {
                this.setNextRange();
            }
        }

        @Override
        protected boolean isInteresting(ASTNode node) {
            return !this.stopProcessing && node.sourceStart() <= this.currentStart && node.sourceEnd() >= this.currentEnd;
        }
    }
}

