/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathMessages;
import org.eclipse.php.internal.ui.preferences.includepath.PHPArchiveFileFilter;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class PHPBuildpathDialogAccess {
    public static IPath[] chooseArchiveEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedPhars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedPhars.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(IncludePathMessages.BuildPathDialogAccess_ZIPArchiveDialog_new_title);
        dialog.setMessage(IncludePathMessages.BuildPathDialogAccess_ZIPArchiveDialog_new_description);
        dialog.addFilter((ViewerFilter)new PHPArchiveFileFilter(usedPhars, true));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static IPath configureArchiveEntry(Shell shell, IPath initialEntry, IPath[] usedEntries) {
        if (initialEntry == null || usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource;
            IPath curr = usedEntries[i];
            if (!curr.equals((Object)initialEntry) && (resource = root.findMember(usedEntries[i])) instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource existing = root.findMember(initialEntry);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(IncludePathMessages.BuildPathDialogAccess_ZIPArchiveDialog_edit_title);
        dialog.setMessage(IncludePathMessages.BuildPathDialogAccess_ZIPArchiveDialog_edit_description);
        dialog.addFilter((ViewerFilter)new PHPArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)existing);
        if (dialog.open() == 0) {
            IResource element = (IResource)dialog.getFirstResult();
            return element.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseExternalArchiveEntries(Shell shell, IEnvironment environment) {
        String lastUsedPath = DLTKUIPlugin.getDefault().getDialogSettings().get("org.eclipse.dltk.ui.lastextzip");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(IncludePathMessages.BuildPathDialogAccess_ExtZIPArchiveDialog_new_title);
        dialog.setFilterExtensions(PHPArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.open();
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        int i = 0;
        while (i < nChosen) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
            elems[i] = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)elems[i]);
            ++i;
        }
        DLTKUIPlugin.getDefault().getDialogSettings().put("org.eclipse.dltk.ui.lastextzip", dialog.getFilterPath());
        return elems;
    }

    public static IPath configureExternalArchiveEntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(IncludePathMessages.BuildPathDialogAccess_ExtZIPArchiveDialog_edit_title);
        dialog.setFilterExtensions(PHPArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        DLTKUIPlugin.getDefault().getDialogSettings().put("org.eclipse.dltk.ui.lastextzip", dialog.getFilterPath());
        return Path.fromOSString((String)res).makeAbsolute();
    }
}

