/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.CurlyCloseAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IAfterNewLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.PairCurlyBracketAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class IndentLineAutoEditStrategy
extends DefaultIndentationStrategy
implements IAutoEditStrategy {
    private final CurlyCloseAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    private final StringBuffer helpBuffer = new StringBuffer();
    IAfterNewLineAutoEditStrategy pairCurlyBracketAutoEditStrategy = new PairCurlyBracketAutoEditStrategy();

    private void autoIndentAfterNewLine(IStructuredDocument document, DocumentCommand command) {
        try {
            IAfterNewLineAutoEditStrategy autoEditStrategy;
            this.helpBuffer.setLength(0);
            this.helpBuffer.append(command.text);
            int currentOffset = command.offset;
            int lineNumber = document.getLineOfOffset(currentOffset);
            this.placeMatchingBlanks(document, this.helpBuffer, lineNumber, command);
            int futureCaretPosition = -1;
            if (currentOffset > 0 && (autoEditStrategy = this.getAfterNewLineAutoEditStrategy(document, command)) != null) {
                futureCaretPosition = autoEditStrategy.autoEditAfterNewLine(document, command, this.helpBuffer);
            }
            IRegion lineInfo = document.getLineInformation(lineNumber);
            int startOffset = lineInfo.getOffset();
            int length = lineInfo.getLength();
            String lineText = document.get(startOffset, length);
            int i = 0;
            while (i < length && (lineText.charAt(i) == ' ' || lineText.charAt(i) == '\t')) {
                ++i;
            }
            if (currentOffset < startOffset + i) {
                command.offset = Math.min(command.offset, startOffset);
                command.length = Math.max(i, command.length);
            }
            command.text = this.helpBuffer.toString();
            if (futureCaretPosition != -1) {
                document.replace(command.offset, command.length, command.text);
                command.length = 0;
                command.text = "";
                command.offset = futureCaretPosition;
                document.getUndoManager().disableUndoManagement();
                document.replace(command.offset, command.length, command.text);
                document.getUndoManager().enableUndoManagement();
            }
        }
        catch (BadLocationException exp) {
            Logger.logException(exp);
        }
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
            this.autoIndentAfterNewLine((IStructuredDocument)document, command);
        }
    }

    private IAfterNewLineAutoEditStrategy getAfterNewLineAutoEditStrategy(IStructuredDocument document, DocumentCommand command) throws BadLocationException {
        if (command.length > 0) {
            return null;
        }
        int offset = command.offset;
        String currentState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)offset, (boolean)true);
        int charPosition = offset;
        char prevChar = '\u0000';
        while (charPosition-- >= 0) {
            prevChar = document.getChar(charPosition);
            if (prevChar != ' ' && prevChar != '\t') break;
        }
        if (TypingPreferences.closeCurlyBracket && prevChar == '{') {
            if (currentState != "org.eclipse.php.PHP_DEFAULT" && document.getLength() == offset) {
                currentState = FormatterUtils.getPartitionType((IStructuredDocument)document, (int)(offset - 1));
            }
            if (currentState == "org.eclipse.php.PHP_DEFAULT") {
                return this.pairCurlyBracketAutoEditStrategy;
            }
        }
        return null;
    }

    private IIndentationStrategy getAutoEditStrategy(char insertionStrtegyKey) {
        switch (insertionStrtegyKey) {
            case '}': {
                return this.curlyCloseAutoEditStrategy;
            }
        }
        return this;
    }

    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, DocumentCommand command) throws BadLocationException {
        int forOffset = command.offset;
        IRegion lineInfo = document.getLineInformation(lineNumber);
        String lineText = document.get(forOffset + command.length, lineInfo.getOffset() + lineInfo.getLength() - (forOffset + command.length));
        String trimedText = lineText.trim();
        char insertionStrategyKey = trimedText.length() == 0 ? (char)'{' : (char)trimedText.charAt(0);
        IIndentationStrategy indentationStrategy = this.getAutoEditStrategy(insertionStrategyKey);
        indentationStrategy.placeMatchingBlanks(document, result, lineNumber, forOffset);
    }
}

