/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RefreshStructureJob
extends Job {
    static final boolean DEBUG;
    private static final long UPDATE_DELAY = 250L;
    private final List fRequests;
    List fViewers = new ArrayList(3);

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/refreshStructure");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public RefreshStructureJob() {
        super(XMLUIMessages.refreshoutline_0);
        this.setPriority(30);
        this.setSystem(true);
        this.fRequests = new ArrayList(2);
    }

    private synchronized void addRequest(Node node) {
        int size = this.fRequests.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                Node node2 = (Node)this.fRequests.get(i);
                if (this.contains(node2, node)) {
                    return;
                }
                if (this.contains(node, node2)) {
                    this.fRequests.set(i, node);
                    return;
                }
                ++i;
            }
        } else {
            this.fRequests.add(node);
        }
    }

    private synchronized void addViewer(StructuredViewer viewer) {
        if (!this.fViewers.contains(viewer)) {
            this.fViewers.add(viewer);
        }
    }

    private boolean contains(Node root, Node possible) {
        if (DEBUG) {
            System.out.println("==============================================================================================================");
            System.out.println("recursive call w/ root: " + root.getNodeName() + " and possible: " + possible);
            System.out.println("--------------------------------------------------------------------------------------------------------------");
        }
        if (root == null) {
            if (DEBUG) {
                System.out.println("returning false: root is null");
            }
            return false;
        }
        if (possible instanceof Document) {
            if (DEBUG) {
                System.out.println("returning false: possible is Document node");
            }
            return false;
        }
        if (root instanceof Document) {
            if (DEBUG) {
                System.out.println("returning true: root is Document node");
            }
            return true;
        }
        Node current = root;
        while (current != null) {
            if (DEBUG) {
                System.out.println("   -> iterating sibling (" + current.getNodeName() + ")");
            }
            if (possible.equals(current)) {
                if (DEBUG) {
                    System.out.println("   !!! found: " + possible.getNodeName() + " in subtree for: " + root.getNodeName());
                }
                return true;
            }
            if (current.getFirstChild() != null) {
                return this.contains(current.getFirstChild(), possible);
            }
            current = current.getNextSibling();
        }
        return false;
    }

    private void doRefresh(final Node node, final StructuredViewer[] viewers) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (DEBUG) {
                    System.out.println("refresh on: [" + node.getNodeName() + "]");
                }
                int i = 0;
                while (i < viewers.length) {
                    if (!viewers[i].getControl().isDisposed()) {
                        StructuredViewer viewer = viewers[i];
                        if (node.getNodeType() == 9 || node.getNodeType() == 1 && ((IDOMNode)node).getFirstStructuredDocumentRegion().getType() == "PHP_CONTENT" && viewer.getContentProvider() instanceof PHPOutlineContentProvider) {
                            viewers[i].refresh(true);
                        } else {
                            viewers[i].refresh((Object)node, true);
                        }
                    } else if (DEBUG) {
                        System.out.println("   !!! skipped refreshing disposed viewer: " + viewers[i]);
                    }
                    ++i;
                }
            }
        });
    }

    private synchronized Object[] getRequests() {
        Node[] toRefresh = this.fRequests.toArray(new Node[this.fRequests.size()]);
        this.fRequests.clear();
        StructuredViewer[] viewers = this.fViewers.toArray(new StructuredViewer[this.fViewers.size()]);
        this.fViewers.clear();
        return new Object[]{toRefresh, viewers};
    }

    public void refresh(StructuredViewer viewer, Node node) {
        if (node == null) {
            return;
        }
        this.addViewer(viewer);
        this.addRequest(node);
        this.schedule(250L);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            Object[] requests = this.getRequests();
            Node[] nodes = (Node[])requests[0];
            StructuredViewer[] viewers = (StructuredViewer[])requests[1];
            int i = 0;
            while (i < nodes.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.doRefresh(nodes[i], viewers);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }
}

