/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
extends VariableBase {
    private Expression name;
    private boolean isDollared;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(Variable.class, "name", Expression.class, true, true);
    public static final SimplePropertyDescriptor DOLLARED_PROPERTY = new SimplePropertyDescriptor(Variable.class, "isDollared", Boolean.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(DOLLARED_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public ChildPropertyDescriptor getNameProperty() {
        return NAME_PROPERTY;
    }

    public SimplePropertyDescriptor getDollaredProperty() {
        return DOLLARED_PROPERTY;
    }

    protected Variable(int start, int end, AST ast, Expression variableName, boolean isDollared) {
        super(start, end, ast);
        if (variableName == null) {
            throw new IllegalArgumentException();
        }
        this.setName(variableName);
        this.setIsDollared(isDollared);
    }

    protected Variable(int start, int end, AST ast, Expression variableName) {
        this(start, end, ast, variableName, false);
    }

    public Variable(int start, int end, AST ast, String variableName) {
        this(start, end, ast, Variable.createIdentifier(start, end, ast, variableName), Variable.checkIsDollared(variableName));
    }

    public Variable(AST ast) {
        super(ast);
    }

    private static boolean checkIsDollared(String variableName) {
        return variableName.indexOf(36) == 0;
    }

    private static Identifier createIdentifier(int start, int end, AST ast, String idName) {
        if (Variable.checkIsDollared(idName)) {
            idName = idName.substring(1);
            ++start;
        }
        return new Identifier(start, end, ast, idName);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.name.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.name.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.name.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Variable");
        this.appendInterval(buffer);
        buffer.append(" isDollared='").append(this.isDollared).append("'>\n");
        this.name.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</Variable>");
    }

    @Override
    public int getType() {
        return 60;
    }

    public boolean isDollared() {
        return this.isDollared;
    }

    public final void setIsDollared(boolean value) {
        SimplePropertyDescriptor dollaredProperty = this.getDollaredProperty();
        this.preValueChange(dollaredProperty);
        this.isDollared = value;
        this.postValueChange(dollaredProperty);
    }

    public Expression getVariableName() {
        return this.name;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.name;
        ChildPropertyDescriptor nameProperty = this.getNameProperty();
        this.preReplaceChild(oldChild, expression, nameProperty);
        this.name = expression;
        this.postReplaceChild(oldChild, expression, nameProperty);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == this.getNameProperty()) {
            if (get) {
                return this.getName();
            }
            this.setName((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == this.getDollaredProperty()) {
            if (get) {
                return this.isDollared();
            }
            this.setIsDollared(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        boolean dollared = this.isDollared();
        Expression name = ASTNode.copySubtree(target, this.getName());
        Variable result = new Variable(this.getStart(), this.getEnd(), target, name, dollared);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IVariableBinding resolveVariableBinding() {
        return this.ast.getBindingResolver().resolveVariable(this);
    }
}

