/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.format.htmlFormatters.HTMLFormatterNoPHPFactory;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

public class PhpFormatProcessorImpl
extends HTMLFormatProcessorImpl {
    protected String getFileExtension() {
        return "php";
    }

    protected IStructuredFormatter getFormatter(Node node) {
        return HTMLFormatterNoPHPFactory.getInstance().createFormatter(node, this.getFormatPreferences());
    }

    protected void refreshFormatPreferences() {
        super.refreshFormatPreferences();
    }

    public void formatDocument(IDocument document, int start, int length) throws IOException, CoreException {
        if (document == null) {
            return;
        }
        if (start >= 0 && length >= 0) {
            if (start + length > document.getLength()) {
                if (start > document.getLength()) {
                    return;
                }
                length = document.getLength() - start;
            }
            IStructuredModel structuredModel = null;
            try {
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
                this.formatModel(structuredModel, start, length);
                if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                    structuredModel.save();
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromEdit();
                }
            }
        }
    }

    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        HTMLFormatterNoPHPFactory.getInstance().start = start;
        HTMLFormatterNoPHPFactory.getInstance().length = length;
        super.formatModel(structuredModel, start, length);
    }
}

