/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.index;

import java.util.regex.Pattern;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.IElementResolver;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.model.IncludeField;

public class PhpElementResolver
implements IElementResolver {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");
    private static final String[] EMPTY = new String[0];

    public IModelElement resolve(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String qualifier, String parent, ISourceModule sourceModule) {
        Object parentElement = (ModelElement)sourceModule;
        if (qualifier != null) {
            parentElement = new IndexType((ModelElement)parentElement, qualifier, 2048, 0, 0, 0, 0, null);
        }
        if (parent != null) {
            parentElement = new SourceType(parentElement, parent);
        }
        switch (elementType) {
            case 7: {
                String[] superClassNames = null;
                if (metadata != null) {
                    superClassNames = SEPARATOR_PATTERN.split(metadata);
                }
                return new IndexType((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, superClassNames);
            }
            case 9: {
                String[] parameters = metadata != null ? SEPARATOR_PATTERN.split(metadata) : EMPTY;
                return new IndexMethod((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength, parameters);
            }
            case 8: {
                return new IndexField((ModelElement)parentElement, elementName, flags, offset, length, nameOffset, nameLength);
            }
            case 12: {
                return new IncludeField((ModelElement)parentElement, metadata);
            }
        }
        Logger.log(2, String.valueOf(PhpElementResolver.class.getName()) + ": Unsupported element type (" + elementType + ")");
        return null;
    }

    private static class IndexField
    extends SourceField {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;

        public IndexField(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.nameRange;
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }
    }

    private static class IndexMethod
    extends SourceMethod {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String[] parameters;

        public IndexMethod(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String[] parameters) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.parameters = parameters;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.nameRange;
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public String[] getParameters() throws ModelException {
            return this.parameters;
        }

        public boolean isConstructor() throws ModelException {
            return (this.flags & 0x100000) != 0;
        }
    }

    private static class IndexType
    extends SourceType {
        private int flags;
        private ISourceRange sourceRange;
        private ISourceRange nameRange;
        private String[] superClassNames;

        public IndexType(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength, String[] superClassNames) {
            super(parent, name);
            this.flags = flags;
            this.sourceRange = new SourceRange(offset, length);
            this.nameRange = new SourceRange(nameOffset, nameLength);
            this.superClassNames = superClassNames;
        }

        public int getFlags() throws ModelException {
            return this.flags;
        }

        public ISourceRange getNameRange() throws ModelException {
            return this.nameRange;
        }

        public ISourceRange getSourceRange() throws ModelException {
            return this.sourceRange;
        }

        public String[] getSuperClasses() throws ModelException {
            return this.superClassNames;
        }
    }
}

