/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.php.core.language.ILanguageModelProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.language.DefaultLanguageModelProvider;
import org.eclipse.php.internal.core.language.LanguageModelContainer;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.project.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;

public class LanguageModelInitializer
extends BuildpathContainerInitializer {
    public static final String PHP_LANGUAGE_LIBRARY = "PHP Language Library";
    public static final String CONTAINER_PATH = "org.eclipse.php.core.LANGUAGE";
    public static final Path LANGUAGE_CONTAINER_PATH = new Path("org.eclipse.php.core.LANGUAGE");
    private Map<IProject, IPreferencesPropagatorListener> project2PhpVerListener = new HashMap<IProject, IPreferencesPropagatorListener>();
    private static ILanguageModelProvider[] providers;

    private void initializeListener(final IPath containerPath, final IScriptProject scriptProject) {
        final IProject project = scriptProject.getProject();
        if (this.project2PhpVerListener.containsKey(project)) {
            return;
        }
        IPreferencesPropagatorListener versionChangeListener = new IPreferencesPropagatorListener(){

            public void preferencesEventOccured(PreferencesPropagatorEvent event) {
                try {
                    LanguageModelInitializer.this.initialize(containerPath, scriptProject);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }

            public IProject getProject() {
                return project;
            }
        };
        this.project2PhpVerListener.put(project, versionChangeListener);
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(versionChangeListener);
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(project, new IProjectClosedObserver(){

            public void closed() {
                PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener((IPreferencesPropagatorListener)LanguageModelInitializer.this.project2PhpVerListener.remove(project));
            }
        });
    }

    public void initialize(IPath containerPath, IScriptProject scriptProject) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals(CONTAINER_PATH)) {
            try {
                if (LanguageModelInitializer.isPHPProject(scriptProject)) {
                    DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{scriptProject}, (IBuildpathContainer[])new IBuildpathContainer[]{new LanguageModelContainer(containerPath)}, null);
                    this.initializeListener(containerPath, scriptProject);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    private static boolean isPHPProject(IScriptProject project) {
        String nature = LanguageModelInitializer.getNatureFromProject(project);
        return "org.eclipse.php.core.PHPNature".equals(nature);
    }

    private static String getNatureFromProject(IScriptProject project) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        if (languageToolkit != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public static boolean isLanguageModelElement(IModelElement element) {
        IScriptProject project;
        IProjectFragment fragment = (IProjectFragment)element.getAncestor(3);
        if (fragment != null && (project = element.getScriptProject()) != null) {
            IPath[] iPathArray = LanguageModelInitializer.getContainerPaths(project);
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()).equals((Object)path)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void enableLanguageModelFor(IScriptProject project) throws ModelException {
        IBuildpathEntry[] rawBuildpath;
        if (!LanguageModelInitializer.isPHPProject(project)) {
            return;
        }
        boolean found = false;
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath = project.getRawBuildpath();
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.isContainerEntry() && entry.getPath().equals((Object)LANGUAGE_CONTAINER_PATH)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            IBuildpathEntry containerEntry = DLTKCore.newContainerEntry((IPath)LANGUAGE_CONTAINER_PATH);
            int newSize = rawBuildpath.length + 1;
            ArrayList<IBuildpathEntry> newRawBuildpath = new ArrayList<IBuildpathEntry>(newSize);
            newRawBuildpath.addAll(Arrays.asList(rawBuildpath));
            newRawBuildpath.add(containerEntry);
            project.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newSize]), null);
        }
    }

    static ILanguageModelProvider[] getContributedProviders() {
        if (providers == null) {
            IConfigurationElement[] elements;
            LinkedList<ILanguageModelProvider> providers = new LinkedList<ILanguageModelProvider>();
            providers.add(new DefaultLanguageModelProvider());
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.languageModelProviders");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("provider")) {
                    try {
                        providers.add((ILanguageModelProvider)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            LanguageModelInitializer.providers = providers.toArray(new ILanguageModelProvider[providers.size()]);
        }
        return providers;
    }

    private static IPath[] getContainerPaths(IScriptProject project) {
        LinkedList<IPath> paths = new LinkedList<IPath>();
        ILanguageModelProvider[] iLanguageModelProviderArray = LanguageModelInitializer.getContributedProviders();
        int n = iLanguageModelProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguageModelProvider provider = iLanguageModelProviderArray[n2];
            IPath path = provider.getPath(project);
            if (path != null) {
                paths.add(path);
            }
            ++n2;
        }
        return paths.toArray(new IPath[paths.size()]);
    }
}

