/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.context;

import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.INamespaceContext;

public class FileContext
extends BasicContext
implements INamespaceContext {
    private String namespaceName;

    public FileContext(ISourceModule sourceModule, ModuleDeclaration rootNode) {
        super(sourceModule, rootNode);
    }

    public FileContext(ISourceModule sourceModule, ModuleDeclaration rootNode, int offset) {
        super(sourceModule, rootNode);
        IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
        if (currentNamespace != null) {
            this.namespaceName = currentNamespace.getElementName();
        }
    }

    public FileContext(ISourceModuleContext parent) {
        super(parent);
        if (parent instanceof INamespaceContext) {
            this.namespaceName = ((INamespaceContext)parent).getNamespace();
        }
    }

    public String getNamespace() {
        return this.namespaceName;
    }

    public void setNamespace(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.namespaceName == null ? 0 : this.namespaceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileContext other = (FileContext)obj;
        return !(this.namespaceName == null ? other.namespaceName != null : !this.namespaceName.equals(other.namespaceName));
    }
}

