/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class PHPDocClassVariableEvaluator
extends AbstractPHPGoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocClassVariableEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        int n;
        PHPDocClassVariableGoal typedGoal = (PHPDocClassVariableGoal)this.goal;
        TypeContext context = (TypeContext)typedGoal.getContext();
        String variableName = typedGoal.getVariableName();
        IType[] types = PHPTypeInferenceUtils.getModelElements(context.getInstanceType(), (ISourceModuleContext)context);
        HashSet<PHPDocBlock> docs = new HashSet<PHPDocBlock>();
        if (types != null) {
            IType[] iTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                block10: {
                    IType type = iTypeArray[n3];
                    try {
                        IType[] superTypes;
                        ITypeHierarchy superHierarchy = type.newSupertypeHierarchy(null);
                        IType[] iTypeArray2 = superTypes = superHierarchy.getAllTypes();
                        n = superTypes.length;
                        int n4 = 0;
                        while (n4 < n) {
                            PHPDocBlock docBlock;
                            IType superType = iTypeArray2[n4];
                            IField[] typeField = PHPModelUtils.getTypeField(superType, variableName, true);
                            if (typeField.length > 0 && (docBlock = PHPModelUtils.getDocBlock(typeField[0])) != null) {
                                docs.add(docBlock);
                            }
                            ++n4;
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                ++n3;
            }
        }
        for (PHPDocBlock doc : docs) {
            PHPDocTag[] pHPDocTagArray = doc.getTags();
            int n5 = pHPDocTagArray.length;
            int n6 = 0;
            while (n6 < n5) {
                PHPDocTag tag = pHPDocTagArray[n6];
                if (tag.getTagKind() == 12) {
                    SimpleReference[] references;
                    SimpleReference[] simpleReferenceArray = references = tag.getReferences();
                    int n7 = references.length;
                    n = 0;
                    while (n < n7) {
                        SimpleReference ref = simpleReferenceArray[n];
                        IEvaluatedType type = PHPClassType.fromSimpleReference(ref);
                        this.evaluated.add(type);
                        ++n;
                    }
                }
                ++n6;
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }
}

