/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.goals;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;

public abstract class AbstractMethodReturnTypeGoal
extends AbstractTypeGoal {
    private final String methodName;
    private IType[] types;
    private IEvaluatedType evaluatedType;

    public AbstractMethodReturnTypeGoal(IContext context, IEvaluatedType evaluatedType, String methodName) {
        super(context);
        Assert.isNotNull((Object)methodName);
        this.methodName = methodName;
        this.evaluatedType = evaluatedType;
    }

    public AbstractMethodReturnTypeGoal(IContext context, IType[] types, String methodName) {
        super(context);
        Assert.isNotNull((Object)methodName);
        this.methodName = methodName;
        this.types = types;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public IType[] getTypes() {
        if (this.types == null && this.evaluatedType != null) {
            this.types = PHPTypeInferenceUtils.getModelElements(this.evaluatedType, (ISourceModuleContext)this.context);
        }
        return this.types;
    }

    public IEvaluatedType getEvaluatedType() {
        return this.evaluatedType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.evaluatedType == null ? 0 : this.evaluatedType.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractMethodReturnTypeGoal other = (AbstractMethodReturnTypeGoal)((Object)obj);
        if (this.evaluatedType == null ? other.evaluatedType != null : !this.evaluatedType.equals(other.evaluatedType)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.types, other.types);
    }
}

