/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.tunneling;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.server.core.tunneling.SSHTunnelSession;

public class SSHTunnel {
    public static final int CONNECTION_ERROR_CODE = 100;
    public static final int CONNECTION_WARNING_CODE = 200;
    public static final int CONNECTION_PASSWORD_CHANGED_CODE = 300;
    private static final int SSH_DEFAULT_PORT = 22;
    private static final String EMPTY_STRING = "";
    private String remoteHost;
    private String localHost;
    private String userName;
    private String password;
    private int localPort;
    private int remotePort;
    private Session session;

    public SSHTunnel(String localHost, String remoteHost, String userName, String password, int localPort, int remotePort) throws IllegalArgumentException {
        this.validateInput(localHost, remoteHost, localPort, remotePort);
        this.remoteHost = remoteHost;
        this.localHost = localHost;
        this.localPort = localPort;
        this.remotePort = remotePort;
        this.userName = userName == null ? EMPTY_STRING : userName;
        this.password = password == null ? EMPTY_STRING : password;
    }

    public IStatus connect() {
        IStatus status = Status.OK_STATUS;
        if (this.isConnected()) {
            return status;
        }
        int retry = 1;
        String newPassword = null;
        while (true) {
            try {
                this.session = SSHTunnelSession.getSession(this.userName, this.password, this.remoteHost, 22, null).getSession();
                Exception ex = null;
                String actualPassword = this.session.getUserInfo().getPassword();
                if (!this.password.equals(actualPassword)) {
                    newPassword = actualPassword;
                }
                Class<?> sessionClass = this.session.getClass();
                Class[] parameterTypes = new Class[]{Integer.TYPE, String.class, Integer.TYPE};
                try {
                    Object[] values = new Object[]{new Integer(this.remotePort), this.localHost, new Integer(this.localPort)};
                    Method mSetPortForwarding = sessionClass.getMethod("setPortForwardingR", parameterTypes);
                    mSetPortForwarding.invoke((Object)this.session, values);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().toLowerCase().indexOf("already registered") == -1) {
                        ex = e;
                    }
                }
                catch (Exception e) {
                    ex = e;
                }
                if (ex == null) break;
                if (this.isConnected()) {
                    status = new Status(2, "org.eclipse.php.server.core", 200, "The debugger tunnel might not have been initialized", (Throwable)ex);
                    break;
                }
                status = new Status(4, "org.eclipse.php.server.core", 100, "The debugger tunnel connection could not be established", (Throwable)ex);
            }
            catch (JSchException ee) {
                if (--retry < 0) {
                    status = new Status(4, "org.eclipse.php.server.core", 100, "Could not establish a tunnel connection to " + this.remoteHost, (Throwable)ee);
                    break;
                }
                if (this.session == null || !this.session.isConnected()) continue;
                this.session.disconnect();
                continue;
            }
            break;
        }
        if (newPassword != null) {
            this.password = newPassword;
        }
        if (status.isOK() && newPassword != null) {
            status = new Status(1, "org.eclipse.php.server.core", 300, newPassword, null);
        }
        return status;
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isConnected();
        }
        return false;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int hashCode() {
        return this.remoteHost.hashCode() * this.localHost.hashCode() * this.userName.hashCode() * (this.localPort + 1) * (this.remotePort + 1);
    }

    public boolean equals(Object o) {
        if (o instanceof SSHTunnel) {
            SSHTunnel other = (SSHTunnel)o;
            return this.remoteHost.equals(other.remoteHost) && this.localHost.equals(other.localHost) && this.userName.equals(other.userName) && this.localPort == other.localPort && this.remotePort == other.remotePort;
        }
        return false;
    }

    private void validateInput(String localHost, String remoteHost, int localPort, int remotePort) throws IllegalArgumentException {
        if (localHost == null || remoteHost == null) {
            throw new IllegalArgumentException("Null arument was passed to the SSHTunnel");
        }
        if (localPort < 0 || localPort > 65535 || remotePort < 0 || remotePort > 65535) {
            throw new IllegalArgumentException("Illegal port was passed to the SSHTunnel");
        }
    }
}

