/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SaveActionsConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    private static final int INDENT_VALUE = 20;
    private static final Key PREF_REMOVE_TRAILING_WHITESPACES = new Key("org.eclipse.php.ui", "cleanup.remove_trailing_whitespaces");
    private static final Key PREF_REMOVE_TRAILING_WHITESPACES_ALL = new Key("org.eclipse.php.ui", "cleanup.remove_trailing_whitespaces_all");
    private static final Key PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY = new Key("org.eclipse.php.ui", "cleanup.remove_trailing_whitespaces_ignore_empty");
    private Button doCleanupCheckbox;
    private Button all;
    private Button ignoreEmpty;
    private boolean fRemoveWhitespaces;
    private boolean fAllLines;
    private boolean fIgnoreEmptyLines;
    private IStatus fSaveActionsStatus = new StatusInfo();
    private Group removeWhitespacesGroup;

    public SaveActionsConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, SaveActionsConfigurationBlock.getKeys(), container);
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_REMOVE_TRAILING_WHITESPACES, PREF_REMOVE_TRAILING_WHITESPACES_ALL, PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY};
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite removeWhiteSpaceComposite = this.createRemoveWhiteSpacesContent(parent);
        this.validateSettings(null, null, null);
        return removeWhiteSpaceComposite;
    }

    private Composite createRemoveWhiteSpacesContent(Composite parent) {
        Composite whiteSpacesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        whiteSpacesComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 128, true, false);
        whiteSpacesComposite.setLayoutData((Object)data);
        this.doCleanupCheckbox = new Button(whiteSpacesComposite, 32);
        this.doCleanupCheckbox.setText(PHPUIMessages.getString("SaveActionsConfigurationBlock_0"));
        this.doCleanupCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fRemoveWhitespaces = !SaveActionsConfigurationBlock.this.fRemoveWhitespaces;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.removeWhitespacesGroup = this.createGroup(2, whiteSpacesComposite, "");
        data = new GridData();
        data.horizontalIndent += 20;
        this.removeWhitespacesGroup.setLayoutData((Object)data);
        this.all = new Button((Composite)this.removeWhitespacesGroup, 16);
        this.all.setText(PHPUIMessages.getString("SaveActionsConfigurationBlock_2"));
        this.all.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fAllLines = true;
                SaveActionsConfigurationBlock.this.fIgnoreEmptyLines = false;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.ignoreEmpty = new Button((Composite)this.removeWhitespacesGroup, 16);
        this.ignoreEmpty.setText(PHPUIMessages.getString("SaveActionsConfigurationBlock_3"));
        this.ignoreEmpty.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SaveActionsConfigurationBlock.this.fAllLines = false;
                SaveActionsConfigurationBlock.this.fIgnoreEmptyLines = true;
                SaveActionsConfigurationBlock.this.updateValues();
            }
        });
        this.initValues();
        this.updateValues();
        return whiteSpacesComposite;
    }

    protected void updateControls() {
        this.initValues();
        this.updateValues();
    }

    private void initValues() {
        String remove = this.getValue(PREF_REMOVE_TRAILING_WHITESPACES);
        String all = this.getValue(PREF_REMOVE_TRAILING_WHITESPACES_ALL);
        String ignore = this.getValue(PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY);
        this.fRemoveWhitespaces = Boolean.valueOf(remove);
        this.fAllLines = Boolean.valueOf(all);
        this.fIgnoreEmptyLines = Boolean.valueOf(ignore);
    }

    private void updateValues() {
        this.doCleanupCheckbox.setSelection(this.fRemoveWhitespaces);
        this.removeWhitespacesGroup.setEnabled(this.fRemoveWhitespaces);
        if (this.fRemoveWhitespaces) {
            this.all.setEnabled(true);
            this.ignoreEmpty.setEnabled(true);
            this.all.setSelection(this.fAllLines);
            this.ignoreEmpty.setSelection(this.fIgnoreEmptyLines);
        }
    }

    protected Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)SaveActionsConfigurationBlock.createGridData(numColumns, 768, -1));
        GridLayout layout = new GridLayout(numColumns, false);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    protected static GridData createGridData(int numColumns, int style, int widthHint) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        gd.widthHint = widthHint;
        return gd;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        if (changedKey == null) {
            this.fSaveActionsStatus = new StatusInfo();
        }
        this.fContext.statusChanged(this.fSaveActionsStatus);
    }

    private void savePreferences() {
        this.setValue(PREF_REMOVE_TRAILING_WHITESPACES, this.fRemoveWhitespaces);
        this.setValue(PREF_REMOVE_TRAILING_WHITESPACES_ALL, this.fAllLines);
        this.setValue(PREF_REMOVE_TRAILING_WHITESPACES_IGNORE_EMPTY, this.fIgnoreEmptyLines);
    }

    public boolean performApply() {
        this.savePreferences();
        return super.performApply();
    }

    public boolean performOk() {
        this.savePreferences();
        return super.performOk();
    }
}

