/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.viewsupport.ImageDisposer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.buildpath.BuildPathUtils;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.AbstractIncludepathsBlock;
import org.eclipse.php.internal.ui.preferences.includepath.PHPBuildpathOrderingWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPIPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.PHPIncludePathSourcePage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPLibrariesWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPProjectsWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.PHPSourceContainerWorkbookPage;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPIncludePathsBlock
extends AbstractIncludepathsBlock {
    public PHPIncludePathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        super(runnableContext, context, pageToShow, useNewPage, pageContainer);
    }

    protected void initContainerElements() {
        AbstractIncludepathsBlock.BuildPathAdapter adapter = new AbstractIncludepathsBlock.BuildPathAdapter();
        String[] buttonLabels = new String[]{NewWizardMessages.BuildPathsBlock_buildpath_up_button, NewWizardMessages.BuildPathsBlock_buildpath_down_button};
        this.fBuildPathList = new ListDialogField(null, buttonLabels, (ILabelProvider)new PHPIPListLabelProvider());
        this.fBuildPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fBuildPathList.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
        this.fBuildPathList.setUpButtonIndex(0);
        this.fBuildPathList.setDownButtonIndex(1);
        this.fBuildPathDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.BuildPathsBlock_buildpath_button);
        this.fBuildPathDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
    }

    protected IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    protected boolean supportZips() {
        return true;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        IncludePathComposite composite = new IncludePathComposite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder((Composite)composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_source);
        item.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.ui.packagefolder_obj.gif"));
        this.fSourceContainerPage = new PHPIncludePathSourcePage(this.fBuildPathList);
        ((PHPSourceContainerWorkbookPage)this.fSourceContainerPage).registerAddedElementListener(composite);
        item.setData((Object)this.fSourceContainerPage);
        item.setControl(this.fSourceContainerPage.getControl((Composite)folder));
        IWorkbench workbench = DLTKUIPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new PHPProjectsWorkbookPage(this.fBuildPathList, this.fPageContainer);
        this.fProjectsPage.setTitle(PHPUIMessages.getString("IncludePathProjectsPage_Folders_Label"));
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_projects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        this.fLibrariesPage = new PHPLibrariesWorkbookPage(this.supportZips(), this.fBuildPathList, this.fPageContainer);
        this.fLibrariesPage.setTitle(PHPUIMessages.getString("IncludePathLibrariesPage_Folders_Label"));
        this.fLibrariesPage.setScriptProject(this.getScriptProject());
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_libraries);
        item.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = DLTKPluginImages.DESC_TOOL_BUILDPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        PHPBuildpathOrderingWorkbookPage ordpage = new PHPBuildpathOrderingWorkbookPage(this.fBuildPathList);
        this.setTitle(PHPUIMessages.getString("IncludePathOrderPage_Folders_Label"));
        item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("BuildPathsBlock_tab_order"));
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrScriptProject != null) {
            this.fSourceContainerPage.init(this.fCurrScriptProject);
            this.fLibrariesPage.init(this.fCurrScriptProject);
            this.fProjectsPage.init(this.fCurrScriptProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPIncludePathsBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void updateBuildPathStatus() {
    }

    public void configureScriptProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.updateBuildPath();
        PHPIncludePathsBlock.flush(this.fBuildPathList.getElements(), this.getScriptProject(), monitor);
        this.initializeTimeStamps();
        this.updateUI();
    }

    private void updateBuildPath() {
        PHPIncludePathSourcePage includePathSourcePage = (PHPIncludePathSourcePage)this.fSourceContainerPage;
        boolean shouldAddToBuildPath = includePathSourcePage.shouldAddToBuildPath();
        if (!shouldAddToBuildPath) {
            return;
        }
        List<BPListElement> addedElements = includePathSourcePage.getAddedElements();
        ArrayList<IBuildpathEntry> buildPathEntries = new ArrayList<IBuildpathEntry>();
        if (addedElements.size() > 0) {
            for (BPListElement listElement : addedElements) {
                if (BuildPathUtils.isContainedInBuildpath((IPath)listElement.getPath(), (IScriptProject)this.fCurrScriptProject)) continue;
                buildPathEntries.add(listElement.getBuildpathEntry());
            }
            try {
                BuildPathUtils.addEntriesToBuildPath((IScriptProject)this.fCurrScriptProject, buildPathEntries);
            }
            catch (ModelException e) {
                Logger.logException((String)"Failed adding entries to build path", (Throwable)e);
            }
        }
    }

    public static void flush(List buildpathEntries, IScriptProject javaProject, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NewWizardMessages.BuildPathsBlock_operationdesc_Script);
        monitor.beginTask("", buildpathEntries.size() * 4 + 4);
        try {
            IProject project = javaProject.getProject();
            project.getFullPath();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ArrayList<IBuildpathEntry> newBuildPathEntries = new ArrayList<IBuildpathEntry>();
            ArrayList<IBuildpathEntry> newIncludePathEntries = new ArrayList<IBuildpathEntry>();
            for (BPListElement entry : buildpathEntries) {
                IResource res;
                newIncludePathEntries.add(entry.getBuildpathEntry());
                if (entry.getEntryKind() != 3) {
                    newBuildPathEntries.add(entry.getBuildpathEntry());
                }
                if ((res = entry.getResource()) instanceof IFolder && entry.getLinkTarget() == null && !res.exists()) {
                    CoreUtility.createFolder((IFolder)((IFolder)res), (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                monitor.worked(1);
            }
            if (newBuildPathEntries.size() > 0) {
                BuildPathUtils.addEntriesToBuildPath((IScriptProject)javaProject, newBuildPathEntries);
            }
            IncludePathManager.getInstance().addEntriesToIncludePath(project, newIncludePathEntries);
        }
        finally {
            monitor.done();
        }
    }

    public void init(IScriptProject jproject, IBuildpathEntry[] buildpathEntries) {
        IncludePath[] includePathEntries;
        this.fCurrScriptProject = jproject;
        ArrayList<BPListElement> newBuildpath = new ArrayList<BPListElement>();
        IProject project = this.fCurrScriptProject.getProject();
        IncludePath[] includePathArray = includePathEntries = IncludePathManager.getInstance().getIncludePaths(project);
        int n = includePathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IncludePath entry = includePathArray[n2];
            Object includePathEntry = entry.getEntry();
            if (includePathEntry instanceof IBuildpathEntry) {
                IBuildpathEntry bpEntry = (IBuildpathEntry)includePathEntry;
                newBuildpath.add(BPListElement.createFromExisting((IBuildpathEntry)bpEntry, (IScriptProject)this.fCurrScriptProject));
            } else {
                IResource resource = (IResource)includePathEntry;
                newBuildpath.add(new BPListElement(this.fCurrScriptProject, 3, resource.getFullPath(), resource, false));
            }
            ++n2;
        }
        this.fBuildPathDialogField.enableButton(project.exists());
        this.fBuildPathList.setElements(newBuildpath);
        this.initializeTimeStamps();
        this.updateUI();
    }

    private final class IncludePathComposite
    extends Composite
    implements IIncludepathListener,
    IChangeListener {
        private IncludePathComposite(Composite parent, int style) {
            super(parent, style);
            IncludePathManager.getInstance().registerIncludepathListener((IIncludepathListener)this);
        }

        public void dispose() {
            if (PHPIncludePathsBlock.this.fSourceContainerPage instanceof PHPIncludePathSourcePage) {
                PHPSourceContainerWorkbookPage page = (PHPSourceContainerWorkbookPage)PHPIncludePathsBlock.this.fSourceContainerPage;
                page.unregisterAddedElementListener(this);
            }
            IncludePathManager.getInstance().unregisterIncludepathListener((IIncludepathListener)this);
            super.dispose();
        }

        public void refresh(IProject project) {
            PHPIncludePathsBlock.this.updateUI();
        }

        public void update(boolean changed) {
            try {
                PHPIncludePathsBlock.this.configureScriptProject((IProgressMonitor)new NullProgressMonitor());
                PHPIncludePathsBlock.this.updateUI();
            }
            catch (OperationCanceledException e) {
                PHPCorePlugin.log((Throwable)e);
            }
            catch (CoreException e) {
                PHPCorePlugin.log((Throwable)e);
            }
        }
    }
}

