/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.actions.AbstractMoveDelegator;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.php.internal.ui.actions.PHPMoveProjectAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ReorgMoveAction
extends AbstractMoveDelegator {
    private static final String MOVE_ELEMENT_ACTION_ID = "org.eclipse.php.ui.actions.Move";
    private IStructuredSelection selectedResources;
    private Shell fShell;
    private AbstractMoveDelegator moveActionDelegate;
    private IContainer target;

    public void run(IStructuredSelection selection) {
        if (ActionUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        if (this.selectedResources != null && !this.selectedResources.isEmpty()) {
            this.createWorkbenchAction(this.selectedResources).run();
        }
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection selection) {
        List list = selection.toList();
        PHPMoveProjectAction action = null;
        if (this.fShell == null) {
            this.fShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (list.size() == 0 || list.get(0) instanceof IProject) {
            action = new PHPMoveProjectAction(this.fShell);
            action.selectionChanged(selection);
        } else if (this.selectedResources != null) {
            action = new MoveResourceAction(this.fShell);
            action.selectionChanged(selection);
        }
        return action;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            if (this.moveActionDelegate != null) {
                this.moveActionDelegate.setActiveEditor(action, targetEditor);
            } else {
                IEditorInput editorInput = targetEditor.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    IFileEditorInput input = (IFileEditorInput)editorInput;
                    IFile file = input.getFile();
                    this.selectedResources = new StructuredSelection((Object)file);
                }
            }
        }
    }

    public void run(IAction action) {
        if (this.moveActionDelegate != null) {
            if (this.target != null) {
                this.moveActionDelegate.setTarget(this.target);
            }
            this.moveActionDelegate.run(action);
        } else {
            this.run(this.selectedResources);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.moveActionDelegate != null) {
            this.moveActionDelegate.selectionChanged(action, selection);
        } else if (selection instanceof IStructuredSelection) {
            this.selectedResources = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void setTarget(IContainer target) {
        this.target = target;
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
        IPHPActionDelegator action = PHPActionDelegatorRegistry.getActionDelegator(MOVE_ELEMENT_ACTION_ID);
        if (action instanceof AbstractMoveDelegator) {
            this.moveActionDelegate = (AbstractMoveDelegator)action;
        }
    }
}

