/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.documentation.BuiltinDoc;
import org.eclipse.wst.sse.core.internal.Logger;

public class PHPDocumentationProvider
implements IScriptDocumentationProvider {
    protected static final String DL_END = "</dl>";
    protected static final String DL_START = "<dl>";
    protected static final String DD_END = "</dd>";
    protected static final String DD_START = "<dd>";
    protected static final String DT_START = "<dt>";
    protected static final String DT_END = "</dt>";
    protected static final String FIELD_LOCATION = "Location";
    protected static final String FIELD_AUTHOR = "Author";
    protected static final String FIELD_CLASS = "Class";
    protected static final String FIELD_DESC = "Description";
    protected static final String FIELD_PARAMETERS = "Parameters";
    protected static final String FIELD_RETURNS = "Returns";
    protected static final String FIELD_THROWS = "Throws";
    protected static final String FIELD_DEPRECATED = "Deprecated";
    protected static final String FIELD_SEEALSO = "See Also";
    protected static final String FIELD_EXTENDS = "Extends";
    protected static final String FIELD_IMPLEMENTS = "Implements";
    protected static final String FIELD_NAMESPACE = "Namespace";
    protected static final String FIELD_INTERFACE = "Interface";
    protected static final String FIELD_TYPE = "Type";

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        StringBuilder buf = new StringBuilder(DL_START);
        try {
            if (!this.appendBuiltinDoc(element, buf)) {
                if (element instanceof IMethod) {
                    this.appendMethodInfo((IMethod)element, buf);
                } else if (element instanceof IType) {
                    this.appendTypeInfo((IType)element, buf);
                } else if (element instanceof IField) {
                    this.appendFieldInfo((IField)element, buf);
                }
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        buf.append(DL_END);
        return new StringReader(buf.toString());
    }

    public Reader getInfo(String keyword) {
        String builtinDoc = BuiltinDoc.getString(keyword);
        if (builtinDoc.length() > 0) {
            StringBuilder buf = new StringBuilder(DL_START);
            buf.append(builtinDoc);
            buf.append(DL_END);
            return new StringReader(buf.toString());
        }
        return null;
    }

    private boolean appendBuiltinDoc(IMember element, StringBuilder buf) {
        String builtinDoc = BuiltinDoc.getString(element.getElementName());
        if (builtinDoc.length() > 0) {
            String fileName = this.getFileName(element);
            this.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
            IType declaringType = element.getDeclaringType();
            this.appendTypeInfoRow(declaringType, buf);
            buf.append(builtinDoc);
            return true;
        }
        return false;
    }

    private void appendMethodInfo(IMethod method, StringBuilder buf) throws ModelException {
        ISourceModule sourceModule = method.getSourceModule();
        String fileName = this.getFileName((IMember)method);
        this.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
        IType declaringType = method.getDeclaringType();
        this.appendTypeInfoRow(declaringType, buf);
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        MethodDeclaration methodDeclaration = PHPModelUtils.getNodeByMethod((ModuleDeclaration)module, (IMethod)method);
        if (!(methodDeclaration instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock doc = ((IPHPDocAwareDeclaration)methodDeclaration).getPHPDoc();
        if (doc == null) {
            return;
        }
        this.appendShortDescription(doc, buf);
        this.appendTagInfo(doc, 7, FIELD_PARAMETERS, buf);
        this.appendTagInfo(doc, 6, FIELD_RETURNS, buf);
        this.appendTagInfo(doc, 29, FIELD_THROWS, buf);
        this.appendTagInfo(doc, 8, FIELD_SEEALSO, buf);
        this.appendTagInfo(doc, 2, FIELD_DEPRECATED, buf);
        this.appendTagInfo(doc, 1, FIELD_AUTHOR, buf);
    }

    private void appendTypeInfo(IType type, StringBuilder buf) throws ModelException {
        ISourceModule sourceModule = type.getSourceModule();
        String fileName = this.getFileName((IMember)type);
        this.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
        IType declaringType = type.getDeclaringType();
        this.appendTypeInfoRow(declaringType, buf);
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass((ModuleDeclaration)module, (IType)type);
        if (typeDeclaration instanceof ClassDeclaration) {
            String[] interfaceNames;
            ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
            String superClassName = classDeclaration.getSuperClassName();
            if (superClassName != null) {
                this.appendDefinitionRow(FIELD_EXTENDS, superClassName, buf);
            }
            if ((interfaceNames = classDeclaration.getInterfaceNames()) != null) {
                this.appendDefinitionRows(FIELD_IMPLEMENTS, interfaceNames, buf);
            }
        } else {
            String[] superClassNames = type.getSuperClasses();
            if (superClassNames != null) {
                this.appendDefinitionRows(FIELD_EXTENDS, superClassNames, buf);
            }
        }
        if (!(typeDeclaration instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock doc = ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc();
        if (doc == null) {
            return;
        }
        this.appendShortDescription(doc, buf);
        this.appendTagInfo(doc, 8, FIELD_SEEALSO, buf);
        this.appendTagInfo(doc, 2, FIELD_DEPRECATED, buf);
        this.appendTagInfo(doc, 1, FIELD_AUTHOR, buf);
    }

    private void appendFieldInfo(IField field, StringBuilder buf) throws ModelException {
        ISourceModule sourceModule = field.getSourceModule();
        String fileName = this.getFileName((IMember)field);
        this.appendDefinitionRow(FIELD_LOCATION, fileName, buf);
        IType declaringType = field.getDeclaringType();
        this.appendTypeInfoRow(declaringType, buf);
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        ASTNode node = PHPModelUtils.getNodeByField((ModuleDeclaration)module, (IField)field);
        if (!(node instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock doc = ((IPHPDocAwareDeclaration)node).getPHPDoc();
        if (doc == null) {
            return;
        }
        this.appendShortDescription(doc, buf);
        PHPDocTag[] pHPDocTagArray = doc.getTags();
        int n = pHPDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            if (tag.getTagKind() == 12) {
                SimpleReference[] references = tag.getReferences();
                StringBuilder typeBuf = new StringBuilder();
                SimpleReference[] simpleReferenceArray = references;
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    SimpleReference ref = simpleReferenceArray[n4];
                    if (typeBuf.length() > 0) {
                        typeBuf.append(" | ");
                    }
                    typeBuf.append(ref.getName());
                    ++n4;
                }
                this.appendDefinitionRow(FIELD_TYPE, typeBuf.toString(), buf);
            }
            ++n2;
        }
    }

    private void appendTypeInfoRow(IType type, StringBuilder buf) {
        if (type == null) {
            return;
        }
        int flags = 0;
        try {
            flags = type.getFlags();
        }
        catch (ModelException modelException) {}
        if (PHPFlags.isNamespace((int)flags)) {
            this.appendDefinitionRow(FIELD_NAMESPACE, type.getElementName(), buf);
        } else if (PHPFlags.isInterface((int)flags)) {
            this.appendDefinitionRow(FIELD_INTERFACE, type.getElementName(), buf);
        } else {
            this.appendDefinitionRow(FIELD_CLASS, type.getElementName(), buf);
        }
    }

    protected String nl2br(String str) {
        return str.replaceAll("\\n", "<br>");
    }

    protected void appendDefinitionRow(String field, String data, StringBuilder buf) {
        buf.append(DT_START).append(field).append(DT_END);
        buf.append(DD_START).append(data).append(DD_END);
    }

    protected void appendDefinitionRows(String field, String[] data, StringBuilder buf) {
        buf.append(DT_START).append(field).append(DT_END);
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            buf.append(DD_START).append(row).append(DD_END);
            ++n2;
        }
    }

    protected void appendShortDescription(PHPDocBlock doc, StringBuilder buf) {
        String desc = doc.getShortDescription();
        if (desc != null && desc.length() > 0) {
            this.appendDefinitionRow(FIELD_DESC, this.nl2br(desc), buf);
        }
    }

    protected void appendTagInfo(PHPDocBlock doc, int tagKind, String field, StringBuilder buf) {
        PHPDocTag[] tags = this.getTags(doc, tagKind);
        if (tags.length > 0) {
            buf.append(DT_START).append(field).append(DT_END);
            PHPDocTag[] pHPDocTagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                buf.append(DD_START).append(tag.getValue()).append(DD_END);
                ++n2;
            }
        }
    }

    protected PHPDocTag[] getTags(PHPDocBlock doc, int kind) {
        LinkedList<PHPDocTag> tags = new LinkedList<PHPDocTag>();
        PHPDocTag[] pHPDocTagArray = doc.getTags();
        int n = pHPDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            if (tag.getTagKind() == kind) {
                tags.add(tag);
            }
            ++n2;
        }
        return tags.toArray(new PHPDocTag[tags.size()]);
    }

    protected String getFileName(IMember modelElement) {
        IPath path = EnvironmentPathUtils.getLocalPath((IPath)modelElement.getSourceModule().getPath());
        String fileName = path.toOSString();
        if (fileName.startsWith("\\") || fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }
}

