/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.ValuedCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPVersionConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    public static final String[] PHP_VERSION_VALUES = new String[]{PHPVersion.PHP4.getAlias(), PHPVersion.PHP5.getAlias(), PHPVersion.PHP5_3.getAlias()};
    public static final String[] PHP_VERSION_DESCRIPTIONS = new String[]{PHPUIMessages.getString("PHPCreationDataModelProvider.0"), PHPUIMessages.getString("PHPCreationDataModelProvider.1"), PHPUIMessages.getString("PHPCreationDataModelProvider.2")};
    private static final Key PREF_PHP_VERSION = PHPVersionConfigurationBlock.getPHPCoreKey("phpVersion");
    private static final Key PREF_ASP_TAGS = PHPVersionConfigurationBlock.getPHPCoreKey("use_asp_tags_as_php");
    private IStatus fTaskTagsStatus;
    protected ValuedCombo versionCombo;
    protected Label nameLabel;

    public PHPVersionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPVersionConfigurationBlock.getKeys(), container);
    }

    public void setEnabled(boolean isEnabled) {
        this.versionCombo.setEnabled(isEnabled);
        this.nameLabel.setEnabled(isEnabled);
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_PHP_VERSION, PREF_ASP_TAGS};
    }

    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createVersionContent(composite);
        this.unpackPHPVersion();
        this.validateSettings(null, null, null);
        return composite;
    }

    private Composite createVersionContent(Composite parent) {
        Composite composite = new Composite(parent, 16);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setText(PHPUIMessages.getString("PHPVersionComboName"));
        GC gc = new GC((Drawable)this.nameLabel);
        gc.setFont(this.nameLabel.getFont());
        gc.dispose();
        List entryList = this.prepareVersionEntryList();
        this.versionCombo = new ValuedCombo(composite, 8, entryList);
        this.versionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = PHPVersionConfigurationBlock.this.versionCombo.getSelectionValue();
                PHPVersionConfigurationBlock.this.setPhpVersionValue(selectedValue);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        if (changedKey != null) {
            if (PREF_PHP_VERSION.equals(changedKey)) {
                this.fTaskTagsStatus = this.validatePHPVersion();
            } else {
                if (!PREF_ASP_TAGS.equals(changedKey)) return;
                this.fTaskTagsStatus = this.validatePHPVersion();
            }
        } else {
            this.fTaskTagsStatus = this.validatePHPVersion();
        }
        this.fContext.statusChanged(this.fTaskTagsStatus);
    }

    private IStatus validatePHPVersion() {
        return new StatusInfo();
    }

    private List prepareVersionEntryList() {
        ArrayList<ValuedCombo.Entry> entryList = new ArrayList<ValuedCombo.Entry>();
        int i = 0;
        while (i < PHP_VERSION_DESCRIPTIONS.length) {
            String description = PHP_VERSION_DESCRIPTIONS[i];
            String value = PHP_VERSION_VALUES[i];
            ValuedCombo.Entry entry = new ValuedCombo.Entry(value, description);
            entryList.add(entry);
            ++i;
        }
        return entryList;
    }

    private void setPhpVersionValue(String value) {
        String[] values = PHP_VERSION_VALUES;
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                this.versionCombo.setText(PHP_VERSION_DESCRIPTIONS[i]);
                this.setValue(PREF_PHP_VERSION, values[i]);
                this.validateSettings(PREF_PHP_VERSION, null, null);
                return;
            }
            ++i;
        }
    }

    private void setUseAspTagsValue(String value) {
        this.setValue(PREF_ASP_TAGS, value);
        this.validateSettings(PREF_ASP_TAGS, null, null);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PHPUIMessages.getString("PHPVersionConfigurationBlock_needsbuild_title");
        String message = workspaceSettings ? PHPUIMessages.getString("PHPVersionConfigurationBlock_needsfullbuild_message") : PHPUIMessages.getString("PHPVersionConfigurationBlock_needsprojectbuild_message");
        return new String[]{title, message};
    }

    protected void updateControls() {
        this.unpackPHPVersion();
    }

    private void unpackPHPVersion() {
        String currTags = this.getValue(PREF_PHP_VERSION);
        this.versionCombo.selectValue(currTags);
    }

    public PHPVersion getPHPVersionValue() {
        return PHPVersion.byAlias((String)this.getValue(PREF_PHP_VERSION));
    }

    public boolean getUseAspTagsValue() {
        return this.getBooleanValue(PREF_ASP_TAGS);
    }
}

