/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Bindings;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;

public class ImplementOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "ImplementOccurrencesFinder";
    private Identifier fIdentifier;
    private TypeDeclaration fTypeDeclaration;
    private ITypeBinding fBinding;

    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (this.isIdendifier(node)) {
            this.fIdentifier = (Identifier)node;
            StructuralPropertyDescriptor locationInParent = this.fIdentifier.getLocationInParent();
            if (locationInParent != ClassDeclaration.SUPER_CLASS_PROPERTY && locationInParent != ClassDeclaration.INTERFACES_PROPERTY && locationInParent != InterfaceDeclaration.INTERFACES_PROPERTY) {
                return "ImplementOccurrencesFinder_invalidTarget";
            }
            IBinding resolvedBinding = this.fIdentifier.resolveBinding();
            if (resolvedBinding == null || !(resolvedBinding instanceof ITypeBinding)) {
                return "ImplementOccurrencesFinder_invalidTarget";
            }
            this.fBinding = (ITypeBinding)resolvedBinding;
            this.fTypeDeclaration = (TypeDeclaration)this.fIdentifier.getParent();
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    private final boolean isIdendifier(ASTNode node) {
        return node != null && node.getType() == 33;
    }

    protected void findOccurrences() {
        this.fDescription = Messages.format(PHPUIMessages.getString("ImplementOccurrencesFinder.3"), this.fIdentifier.getName());
        this.fTypeDeclaration.accept((Visitor)this);
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.fIdentifier.getStart(), this.fIdentifier.getLength(), this.getOccurrenceType((ASTNode)this.fIdentifier), this.fDescription));
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        IMethodBinding method;
        IMethodBinding methodBinding = methodDeclaration.resolveMethodBinding();
        if (methodBinding != null && !PHPFlags.isStatic((int)methodBinding.getModifiers()) && (method = Bindings.findOverriddenMethodInHierarchy((ITypeBinding)this.fBinding, (IMethodBinding)methodBinding)) != null) {
            Identifier name = methodDeclaration.getFunction().getFunctionName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), 0, this.fDescription));
        }
        return super.visit(methodDeclaration);
    }

    protected int getOccurrenceType(ASTNode node) {
        return 8;
    }

    public String getElementName() {
        return this.fIdentifier.getName();
    }

    public String getID() {
        return ID;
    }
}

