/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBaseVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpContainerVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBGpContainerValue
extends DBGpValue {
    private IVariable[] childVariables;
    private int numChild;
    private String className;
    private int page = -1;
    private int pageSize;
    private static final boolean IS_ARRAY = false;
    private static final boolean IS_OBJECT = true;
    private boolean containerType = false;

    public DBGpContainerValue(DBGpBaseVariable owningVariable, Node property) {
        super(owningVariable);
        this.setModifiable(false);
        if (property != null) {
            this.parseData(property);
            this.genValueString("");
        }
    }

    private void parseData(Node property) {
        block10: {
            block9: {
                String type = DBGpResponse.getAttribute(property, "type");
                if (type.equals("object")) {
                    this.containerType = true;
                    this.className = DBGpResponse.getAttribute(property, "classname");
                }
                String numChildStr = DBGpResponse.getAttribute(property, "numchildren");
                this.numChild = 0;
                if (numChildStr != null && numChildStr.trim().length() != 0) {
                    this.numChild = Integer.parseInt(numChildStr);
                }
                String pageStr = null;
                String pageSizeStr = null;
                pageStr = DBGpResponse.getAttribute(property, "page");
                pageSizeStr = DBGpResponse.getAttribute(property, "pagesize");
                this.pageSize = ((DBGpTarget)this.getDebugTarget()).getMaxChildren();
                if (pageSizeStr != null && pageSizeStr.trim().length() != 0) {
                    this.pageSize = Integer.parseInt(pageSizeStr);
                }
                this.page = -1;
                if (pageStr != null && pageStr.trim().length() != 0) {
                    this.page = Integer.parseInt(pageStr);
                }
                if (this.page == -1 && this.numChild > this.pageSize) {
                    this.page = 0;
                }
                if (this.page != -1 && !(this.getOwner() instanceof DBGpContainerVariable)) break block9;
                NodeList childProperties = property.getChildNodes();
                int childrenReceived = childProperties.getLength();
                if (childrenReceived <= 0) break block10;
                this.childVariables = new DBGpVariable[childrenReceived];
                int i = 0;
                while (i < childrenReceived) {
                    Node childProperty = childProperties.item(i);
                    this.childVariables[i] = new DBGpVariable((DBGpTarget)this.getDebugTarget(), childProperty, this.getOwner().getStackLevel());
                    ++i;
                }
                break block10;
            }
            int subCount = this.roundUp((double)this.numChild / (double)this.pageSize);
            this.childVariables = new DBGpContainerVariable[subCount];
            int i = 0;
            while (i < subCount) {
                if (i == this.page) {
                    this.childVariables[i] = new DBGpContainerVariable(this.getDebugTarget(), i, this.pageSize, this.numChild, property, this.getOwner().getStackLevel(), this.getOwner().getFullName());
                } else {
                    this.childVariables[i] = new DBGpContainerVariable(this.getDebugTarget(), i, this.pageSize, this.numChild, null, this.getOwner().getStackLevel(), this.getOwner().getFullName());
                    ((DBGpContainerVariable)this.childVariables[i]).setAddress(this.getOwner().getAddress());
                }
                ++i;
            }
        }
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.containerType) {
            return "object";
        }
        return "array";
    }

    void genValueString(String notUsed) {
        if (!(this.getOwner() instanceof DBGpContainerVariable)) {
            if (this.containerType) {
                if (this.className != null && this.className.trim().length() != 0) {
                    this.setValueString(this.className);
                } else {
                    this.setValueString(PHPDebugCoreMessages.XDebug_DBGpContainerValue_0);
                }
            } else {
                this.setValueString("Array [" + this.numChild + "]");
            }
        }
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.childVariables == null) {
            this.requestValue();
            if (this.childVariables == null) {
                this.childVariables = new IVariable[0];
            }
        }
        return this.childVariables;
    }

    private void requestValue() {
        DBGpTarget target = (DBGpTarget)this.getDebugTarget();
        DBGpBaseVariable var = this.getOwner();
        int page = 0;
        if (var instanceof DBGpContainerVariable) {
            page = ((DBGpContainerVariable)var).getPage();
        }
        Node property = null;
        property = target.getProperty(var.getFullName(), var.getStackLevel(), page);
        if (property != null) {
            this.parseData(property);
        }
    }

    public boolean hasVariables() throws DebugException {
        boolean hasVars = this.childVariables == null || this.childVariables.length > 0;
        return hasVars;
    }

    private int roundUp(double inVal) {
        double fraction = inVal % 1.0;
        double retVal = inVal - fraction;
        if (fraction > 0.0) {
            retVal += 1.0;
        }
        return (int)retVal;
    }
}

