/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.CommentHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.ui.internal.handlers.AddBlockCommentHandler;

public class ToggleCommentHandler
extends CommentHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            ITextSelection textSelection = this.getCurrentSelection(textEditor);
            if (textSelection.isEmpty()) {
                return null;
            }
            if (document instanceof IStructuredDocument) {
                int selectionOffset = textSelection.getOffset();
                IStructuredDocument sDoc = (IStructuredDocument)document;
                if (this.isMoreThanOneContextBlockSelected((IDocument)sDoc, textSelection)) {
                    AddBlockCommentHandler addBlockCommentHandlerWST = new AddBlockCommentHandler();
                    return addBlockCommentHandlerWST.execute(event);
                }
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(selectionOffset);
                }
                boolean isJavaScriptRegion = false;
                if (textRegion instanceof ForeignRegion) {
                    boolean bl = isJavaScriptRegion = textRegion.getType() == "BLOCK_TEXT";
                }
                if (textRegion.getType() == "PHP_CONTENT" || isJavaScriptRegion) {
                    this.processAction(textEditor, document, textSelection);
                } else {
                    org.eclipse.wst.xml.ui.internal.handlers.ToggleCommentHandler toggleCommentHandlerWST = new org.eclipse.wst.xml.ui.internal.handlers.ToggleCommentHandler();
                    return toggleCommentHandlerWST.execute(event);
                }
            }
        }
        return null;
    }

    void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
        int selectionStartLine = textSelection.getStartLine();
        int selectionEndLine = textSelection.getEndLine();
        try {
            int selectionEndLineOffset = document.getLineOffset(selectionEndLine);
            int selectionEndOffset = textSelection.getOffset() + textSelection.getLength();
            if (selectionEndLine > selectionStartLine && selectionEndLineOffset == selectionEndOffset) {
                --selectionEndLine;
            }
        }
        catch (BadLocationException e) {
            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
        }
        Position selectionPosition = null;
        boolean updateStartOffset = false;
        try {
            selectionPosition = new Position(textSelection.getOffset(), textSelection.getLength());
            document.addPosition(selectionPosition);
            int selectionStartLineOffset = document.getLineOffset(selectionStartLine);
            if (textSelection.getLength() > 0 && selectionStartLineOffset == textSelection.getOffset() && !this.isCommentLine(document, selectionStartLine)) {
                updateStartOffset = true;
            }
        }
        catch (BadLocationException e) {
            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
        }
        this.processAction(document, selectionStartLine, selectionEndLine);
        this.updateCurrentSelection(textEditor, selectionPosition, document, updateStartOffset);
    }

    private void processAction(IDocument document, int selectionStartLine, int selectionEndLine) {
        block17: {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            if (model != null) {
                try {
                    model.beginRecording((Object)this, PHPUIMessages.getString("ToggleComment_tooltip"));
                    model.aboutToChangeModel();
                    boolean allLinesCommented = true;
                    int i = selectionStartLine;
                    while (i <= selectionEndLine) {
                        try {
                            if (document.getLineLength(i) > 0 && !this.isCommentLine(document, i)) {
                                allLinesCommented = false;
                                break;
                            }
                        }
                        catch (BadLocationException e) {
                            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                        }
                        ++i;
                    }
                    if (allLinesCommented) {
                        i = selectionStartLine;
                        while (i <= selectionEndLine) {
                            try {
                                if (document.getLineLength(i) > 0) {
                                    int lineOffset = document.getLineOffset(i);
                                    IRegion region = document.getLineInformation(i);
                                    String string = document.get(region.getOffset(), region.getLength());
                                    int openCommentOffset = lineOffset + string.indexOf("//");
                                    this.uncommentSingleLine(document, openCommentOffset);
                                }
                            }
                            catch (BadLocationException e) {
                                Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                            }
                            ++i;
                        }
                        break block17;
                    }
                    i = selectionStartLine;
                    while (i <= selectionEndLine) {
                        try {
                            if (document.getLineLength(i) > 0) {
                                int openCommentOffset = document.getLineOffset(i);
                                this.commentSingleLine(document, openCommentOffset);
                            }
                        }
                        catch (BadLocationException e) {
                            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
                        }
                        ++i;
                    }
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                    model.releaseFromEdit();
                }
            }
        }
    }

    private void updateCurrentSelection(ITextEditor textEditor, Position selectionPosition, IDocument document, boolean updateStartOffset) {
        if (selectionPosition != null) {
            TextSelection selection = null;
            selection = updateStartOffset ? new TextSelection(document, selectionPosition.getOffset() - "//".length(), selectionPosition.getLength() + "/*".length()) : new TextSelection(document, selectionPosition.getOffset(), selectionPosition.getLength());
            ISelectionProvider provider = textEditor.getSelectionProvider();
            if (provider != null) {
                provider.setSelection((ISelection)selection);
            }
            document.removePosition(selectionPosition);
        }
    }
}

