/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.visitor.HierarchicalVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.corext.SourceRange;
import org.eclipse.php.internal.ui.corext.dom.Selection;
import org.eclipse.php.internal.ui.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.corext.dom.fragments.AssociativeInfixExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.SimpleExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.SimpleFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.Util;

public class ASTFragmentFactory {
    public static IASTFragment createFragmentForSourceRange(SourceRange range, ASTNode scope, IDocument document) throws Exception {
        SelectionAnalyzer sa = new SelectionAnalyzer(Selection.createFromStartLength(range.getOffset(), range.getLength()), false);
        scope.accept((Visitor)sa);
        if (ASTFragmentFactory.isSingleNodeSelected(sa, range, document, scope)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(sa.getFirstSelectedNode());
        }
        if (ASTFragmentFactory.isEmptySelectionCoveredByANode(range, sa)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(sa.getLastCoveringNode());
        }
        return ASTFragmentFactory.createFragmentForSubPartBySourceRange(sa.getLastCoveringNode(), range, scope, document);
    }

    private static IASTFragment createFragmentForSubPartBySourceRange(ASTNode node, SourceRange range, ASTNode scope, IDocument document) throws Exception {
        return FragmentForSubPartBySourceRangeFactory.createFragmentFor(node, range, scope, document);
    }

    private static boolean isEmptySelectionCoveredByANode(SourceRange range, SelectionAnalyzer sa) {
        return range.getLength() == 0 && sa.getFirstSelectedNode() == null && sa.getLastCoveringNode() != null;
    }

    private static boolean isSingleNodeSelected(SelectionAnalyzer sa, SourceRange range, IDocument document, ASTNode scope) throws BadLocationException {
        return sa.getSelectedNodes().length == 1 && !ASTFragmentFactory.rangeIncludesNonWhitespaceOutsideNode(range, sa.getFirstSelectedNode(), document, scope);
    }

    private static boolean rangeIncludesNonWhitespaceOutsideNode(SourceRange range, ASTNode node, IDocument document, ASTNode scope) throws BadLocationException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(range, new SourceRange(node), document);
    }

    public static IASTFragment createFragmentForFullSubtree(ASTNode node) {
        IASTFragment result = FragmentForFullSubtreeFactory.createFragmentFor(node);
        Assert.isNotNull((Object)result);
        return result;
    }

    private static abstract class FragmentFactory
    extends HierarchicalVisitor {
        private IASTFragment fFragment;

        private FragmentFactory() {
        }

        protected IASTFragment createFragment(ASTNode node) {
            this.fFragment = null;
            node.accept((Visitor)this);
            return this.fFragment;
        }

        protected final IASTFragment getFragment() {
            return this.fFragment;
        }

        protected final void setFragment(IASTFragment fragment) {
            Assert.isTrue((!this.isFragmentSet() ? 1 : 0) != 0);
            this.fFragment = fragment;
        }

        protected final void clearFragment() {
            this.fFragment = null;
        }

        protected final boolean isFragmentSet() {
            return this.getFragment() != null;
        }
    }

    private static class FragmentForFullSubtreeFactory
    extends FragmentFactory {
        private FragmentForFullSubtreeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode node) {
            return new FragmentForFullSubtreeFactory().createFragment(node);
        }

        public boolean visit(InfixExpression node) {
            IExpressionFragment fragment = AssociativeInfixExpressionFragment.createFragmentForFullSubtree(node);
            if (fragment == null) {
                return this.visit((Expression)node);
            }
            this.setFragment(fragment);
            return false;
        }

        public boolean visit(Expression node) {
            this.setFragment(new SimpleExpressionFragment(node));
            return false;
        }

        public boolean visit(ASTNode node) {
            this.setFragment(new SimpleFragment(node));
            return false;
        }
    }

    private static class FragmentForSubPartBySourceRangeFactory
    extends FragmentFactory {
        private SourceRange fRange;
        private ASTNode fScope;
        private Exception modelException = null;
        private IDocument fDocument;

        private FragmentForSubPartBySourceRangeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode node, SourceRange range, ASTNode scope, IDocument document) throws Exception {
            return new FragmentForSubPartBySourceRangeFactory().createFragment(node, range, scope, document);
        }

        public boolean visit(InfixExpression node) {
            try {
                this.setFragment(FragmentForSubPartBySourceRangeFactory.createInfixExpressionSubPartFragmentBySourceRange(node, this.fRange, this.fScope, this.fDocument));
            }
            catch (Exception e) {
                this.modelException = e;
            }
            return false;
        }

        public boolean visit(ASTNode node) {
            return false;
        }

        protected IASTFragment createFragment(ASTNode node, SourceRange range, ASTNode scope, IDocument document) throws Exception {
            this.fRange = range;
            this.fScope = scope;
            this.fDocument = document;
            IASTFragment result = this.createFragment(node);
            if (this.modelException != null) {
                throw this.modelException;
            }
            return result;
        }

        private static IExpressionFragment createInfixExpressionSubPartFragmentBySourceRange(InfixExpression node, SourceRange range, ASTNode scope, IDocument document) throws Exception {
            return AssociativeInfixExpressionFragment.createSubPartFragmentBySourceRange(node, range, document);
        }
    }
}

