/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;

public class IncludeHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ISourceModule includedSourceModule;
        PHPStructuredEditor editor = org.eclipse.php.internal.ui.util.EditorUtility.getPHPEditor(textViewer);
        if (editor == null) {
            return null;
        }
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)false);
        if (!(input instanceof ISourceModule)) {
            return null;
        }
        final int offset = region.getOffset();
        final String[] file = new String[1];
        final Region[] selectRegion = new Region[1];
        ISourceModule sourceModule = input;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visit(Expression expr) throws ModelException {
                if (expr.sourceStart() < offset && expr.sourceEnd() > offset && expr instanceof Include) {
                    Expression fileExpr = ((Include)expr).getExpr();
                    if (fileExpr instanceof Scalar) {
                        file[0] = ASTUtils.stripQuotes((String)((Scalar)fileExpr).getValue());
                        selectRegion[0] = new Region(fileExpr.sourceStart(), fileExpr.sourceEnd() - fileExpr.sourceStart());
                    }
                    this.found = true;
                    return false;
                }
                return !this.found;
            }

            public boolean visitGeneral(ASTNode n) {
                return !this.found;
            }
        };
        try {
            moduleDeclaration.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        if (file[0] != null && (includedSourceModule = FileNetworkUtility.findSourceModule((ISourceModule)sourceModule, (String)file[0])) != null) {
            return new IHyperlink[]{new ModelElementHyperlink((IRegion)selectRegion[0], (Object)includedSourceModule, new OpenAction((IEditorPart)editor))};
        }
        return null;
    }
}

