/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.FunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.typeinference.BindingUtility;

public class MethodBinding
extends FunctionBinding
implements IMethodBinding {
    private ITypeBinding declaringClassTypeBinding;

    public MethodBinding(BindingResolver resolver, IMethod modelElement) {
        super(resolver, modelElement);
    }

    public ITypeBinding getDeclaringClass() {
        IType parent;
        if (this.declaringClassTypeBinding == null && (parent = this.modelElement.getDeclaringType()) instanceof IType) {
            this.declaringClassTypeBinding = this.resolver.getTypeBinding(parent);
        }
        return this.declaringClassTypeBinding;
    }

    public boolean isConstructor() {
        try {
            return this.modelElement.isConstructor();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean overrides(IMethodBinding method) {
        int otherModifiers;
        if (this.isConstructor() || method.isConstructor()) {
            return false;
        }
        if (this.getDeclaringClass().isSubTypeCompatible(method.getDeclaringClass()) && this.getName().equalsIgnoreCase(method.getName()) && ((otherModifiers = method.getModifiers()) & 4) == 0) {
            if ((otherModifiers & 0x10) != 0) {
                return false;
            }
            int thisModifiers = this.getModifiers();
            if ((otherModifiers & 0x40) != 0 || false) {
                return (thisModifiers & 0x40) != 0 || false;
            }
            if ((otherModifiers & 0x20) != 0) {
                return (thisModifiers & 0x20) != 0 || (thisModifiers & 0x40) != 0 || false;
            }
        }
        return false;
    }

    public ITypeBinding[] getReturnType() {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        ISourceModule sourceModule = this.modelElement.getSourceModule();
        try {
            int flags = this.modelElement.getFlags();
            if (!PHPFlags.isAbstract((int)flags)) {
                IEvaluatedType[] evaluatedFunctionReturnTypes;
                BindingUtility bindingUtility = new BindingUtility(sourceModule);
                IEvaluatedType[] iEvaluatedTypeArray = evaluatedFunctionReturnTypes = bindingUtility.getFunctionReturnType(this.modelElement);
                int n = evaluatedFunctionReturnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IEvaluatedType currentEvaluatedType = iEvaluatedTypeArray[n2];
                    ITypeBinding typeBinding = this.resolver.getTypeBinding(currentEvaluatedType, sourceModule);
                    result.add(typeBinding);
                    ++n2;
                }
            } else {
                IModelElement parentElement = this.modelElement.getParent();
                if (parentElement instanceof IType) {
                    IType[] functionReturnTypes;
                    IType parent = (IType)parentElement;
                    IType[] iTypeArray = functionReturnTypes = CodeAssistUtils.getFunctionReturnType(new IType[]{parent}, this.modelElement.getElementName(), 32, this.modelElement.getSourceModule(), 0);
                    int n = functionReturnTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType currentEvaluatedType = iTypeArray[n3];
                        ITypeBinding typeBinding = this.resolver.getTypeBinding(currentEvaluatedType);
                        result.add(typeBinding);
                        ++n3;
                    }
                }
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }
}

