/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPSelectionEngine
extends ScriptSelectionEngine {
    private static final String OPEN_BRACE = "(";
    private static final String PROTECTED = "protected";
    private static final String PUBLIC = "public";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final String NS_SEPARATOR = "\\";
    private static final String CONST = "const";
    private static final String THIS = "this";
    private static final String STATIC = "static";
    private static final String PRIVATE = "private";
    private static final String VAR = "var";
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private static final String NEW = "new";
    private static final String INTERFACE = "interface";
    private static final String CLASS = "class";
    private static final String FUNCTION = "function";
    private static final IModelElement[] EMPTY = new IModelElement[0];
    private PHPVersion phpVersion;

    public IAssistParser getParser() {
        return null;
    }

    public IModelElement[] select(ISourceModule sourceUnit, int offset, int end) {
        IModelElement[] elements;
        IStructuredDocument document;
        org.eclipse.dltk.core.ISourceModule sourceModule;
        block17: {
            if (!PHPCorePlugin.toolkitInitialized) {
                return EMPTY;
            }
            if (end < offset) {
                end = offset + 1;
            }
            sourceModule = (org.eclipse.dltk.core.ISourceModule)sourceUnit.getModelElement();
            this.phpVersion = ProjectOptions.getPhpVersion(sourceModule.getScriptProject().getProject());
            try {
                IModelElement[] elements2 = this.internalASTResolve(sourceModule, offset, end);
                if (elements2 != null) {
                    Collection<IModelElement> filtered = PHPModelUtils.filterElements(sourceModule, Arrays.asList(elements2));
                    return filtered.toArray(new IModelElement[filtered.size()]);
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
            document = null;
            IStructuredModel structuredModel = null;
            try {
                try {
                    IFile file = (IFile)sourceUnit.getModelElement().getResource();
                    if (file != null) {
                        if (file.exists()) {
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                            document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                        } else {
                            document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                            document.set(sourceUnit.getSourceContents());
                        }
                    }
                }
                catch (Exception e) {
                    PHPCorePlugin.log(e);
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        if (document != null && (elements = this.internalResolve(document, sourceModule, offset, end)) != null) {
            Collection<IModelElement> filtered = PHPModelUtils.filterElements(sourceModule, Arrays.asList(elements));
            return filtered.toArray(new IModelElement[filtered.size()]);
        }
        return EMPTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IModelElement[] internalASTResolve(org.eclipse.dltk.core.ISourceModule sourceModule, int offset, int end) throws ModelException {
        IModelElement element;
        IContext context;
        ModuleDeclaration parsedUnit;
        ASTNode node;
        String source = sourceModule.getSource();
        offset = PHPTextSequenceUtilities.readIdentifierStartIndex(source, offset, true);
        int methodEnd = PHPTextSequenceUtilities.getMethodEndIndex(source, end = PHPTextSequenceUtilities.readIdentifierEndIndex(source, end, true));
        if (methodEnd != -1) {
            end = methodEnd;
        }
        if ((node = ASTUtils.findMinimalNode(parsedUnit = SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)sourceModule, null), offset, end)) == null || (context = ASTUtils.findContext(sourceModule, parsedUnit, node)) == null) return null;
        if (node instanceof PHPCallExpression) {
            PHPCallExpression callExpression = (PHPCallExpression)node;
            if (callExpression.getReceiver() != null) {
                IEvaluatedType receiverType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, callExpression.getReceiver());
                if (receiverType == null) return null;
                IType[] elements = PHPTypeInferenceUtils.getModelElements(receiverType, (ISourceModuleContext)context, offset);
                LinkedList<IMethod> methods = new LinkedList<IMethod>();
                if (elements == null) return methods.toArray(new IModelElement[methods.size()]);
                IType[] iTypeArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IType element2 = iTypeArray[n2];
                    if (element2 instanceof IType) {
                        IType type = element2;
                        try {
                            methods.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyMethod(type, callExpression.getName(), true, null)));
                        }
                        catch (CoreException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    ++n2;
                }
                return methods.toArray(new IModelElement[methods.size()]);
            }
            SimpleReference callName = callExpression.getCallName();
            String methodName = callName instanceof FullyQualifiedReference ? ((FullyQualifiedReference)callName).getFullyQualifiedName() : callName.getName();
            IMethod[] functions = PHPModelUtils.getFunctions(methodName, sourceModule, offset, null);
            return functions == null ? EMPTY : functions;
        }
        if (node instanceof StaticDispatch) {
            IEvaluatedType dispatcherType;
            Expression field;
            StaticDispatch dispatch = (StaticDispatch)node;
            String fieldName = null;
            if (dispatch instanceof StaticConstantAccess) {
                fieldName = ((StaticConstantAccess)dispatch).getConstant().getName();
            } else if (dispatch instanceof StaticFieldAccess && (field = ((StaticFieldAccess)dispatch).getField()) instanceof VariableReference) {
                fieldName = ((VariableReference)field).getName();
            }
            if (fieldName == null || dispatch.getDispatcher() == null || (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)dispatch.getDispatcher())) == null) return null;
            IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
            LinkedList<IField> fields = new LinkedList<IField>();
            if (elements == null) return fields.toArray(new IModelElement[fields.size()]);
            IType[] iTypeArray = elements;
            int n = elements.length;
            int n3 = 0;
            while (n3 < n) {
                IType element3 = iTypeArray[n3];
                if (element3 instanceof IType) {
                    IType type = element3;
                    try {
                        fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, fieldName, true)));
                    }
                    catch (ModelException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                ++n3;
            }
            return fields.toArray(new IModelElement[fields.size()]);
        }
        if (node instanceof FieldAccess) {
            IEvaluatedType dispatcherType;
            FieldAccess fieldAccess = (FieldAccess)node;
            Expression field = fieldAccess.getField();
            String fieldName = null;
            if (field instanceof SimpleReference) {
                fieldName = ((SimpleReference)field).getName();
            }
            if (fieldName == null || fieldAccess.getDispatcher() == null || (dispatcherType = PHPTypeInferenceUtils.resolveExpression(sourceModule, parsedUnit, context, (ASTNode)fieldAccess.getDispatcher())) == null) return null;
            IType[] elements = PHPTypeInferenceUtils.getModelElements(dispatcherType, (ISourceModuleContext)context, offset);
            LinkedList<IField> fields = new LinkedList<IField>();
            if (elements == null) return fields.toArray(new IModelElement[fields.size()]);
            IType[] iTypeArray = elements;
            int n = elements.length;
            int n4 = 0;
            while (n4 < n) {
                IType element4 = iTypeArray[n4];
                if (element4 instanceof IType) {
                    IType type = element4;
                    try {
                        fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, fieldName, true)));
                    }
                    catch (ModelException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                ++n4;
            }
            return fields.toArray(new IModelElement[fields.size()]);
        }
        if (node instanceof NamespaceReference) {
            String name = ((NamespaceReference)node).getName();
            IType[] namespace = PHPModelUtils.getNamespaceOf(String.valueOf(name) + '\\', sourceModule, offset);
            return namespace == null ? EMPTY : namespace;
        }
        if (node instanceof TypeReference) {
            String name = node instanceof FullyQualifiedReference ? ((FullyQualifiedReference)node).getFullyQualifiedName() : ((TypeReference)node).getName();
            IType[] types = PHPModelUtils.getTypes(name, sourceModule, offset, null);
            if (types != null && types.length != 0) return types;
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
            types = PhpModelAccess.getDefault().findTypes(null, name, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null);
            if (types != null && types.length != 0) return types;
            return PHPModelUtils.getFields(name, sourceModule, offset, null);
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation newNode = (ClassInstanceCreation)node;
            Expression className = newNode.getClassName();
            if (!(className instanceof SimpleReference)) return null;
            String name = className instanceof FullyQualifiedReference ? ((FullyQualifiedReference)className).getFullyQualifiedName() : ((SimpleReference)className).getName();
            return PHPSelectionEngine.getConstructorsIfAny(PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(name, sourceModule, offset, null)));
        }
        if (!(node instanceof TypeDeclaration) && !(node instanceof MethodDeclaration) || ((Declaration)node).getNameStart() > offset || ((Declaration)node).getNameEnd() < offset || (element = sourceModule.getElementAt(node.sourceStart())) == null) return null;
        return new IModelElement[]{element};
    }

    private IModelElement[] internalResolve(IStructuredDocument sDoc, org.eclipse.dltk.core.ISourceModule sourceModule, int offset, int end) {
        block39: {
            try {
                IType containerType;
                String nextWord;
                String prevWord;
                String elementName;
                int startPosition;
                TextSequence statement;
                int elementStart;
                ITextRegion tRegion;
                block40: {
                    IModelElement[] generalizationTypes;
                    boolean isClassDeclaration;
                    int endPosition;
                    block42: {
                        block41: {
                            IStructuredDocumentRegion sRegion = sDoc.getRegionAtCharacterOffset(offset);
                            if (sRegion == null) break block39;
                            tRegion = sRegion.getRegionAtCharacterOffset(offset);
                            IStructuredDocumentRegion container = sRegion;
                            if (tRegion instanceof ITextRegionContainer) {
                                container = (ITextRegionContainer)tRegion;
                                tRegion = container.getRegionAtCharacterOffset(offset);
                            }
                            if (tRegion.getType() != "PHP_CONTENT") break block39;
                            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)tRegion;
                            tRegion = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
                            elementStart = container.getStartOffset() + phpScriptRegion.getStart() + tRegion.getStart();
                            statement = PHPTextSequenceUtilities.getStatement(elementStart + tRegion.getLength(), sRegion, true);
                            endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statement, statement.length());
                            startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, endPosition, true);
                            elementName = statement.subSequence(startPosition, endPosition).toString();
                            int prevWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, startPosition);
                            int prevWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.phpVersion, statement, prevWordEnd, false);
                            prevWord = statement.subSequence(prevWordStart, prevWordEnd).toString();
                            ITextRegion nextRegion = tRegion;
                            while ((PHPPartitionTypes.isPHPCommentState((nextRegion = phpScriptRegion.getPhpToken(nextRegion.getEnd())).getType()) || nextRegion.getType() == "WHITESPACE") && nextRegion.getEnd() < phpScriptRegion.getLength()) {
                            }
                            nextWord = sDoc.get(container.getStartOffset() + phpScriptRegion.getStart() + nextRegion.getStart(), nextRegion.getTextLength());
                            if (elementName.length() <= 0) break block39;
                            containerType = PHPModelUtils.getCurrentType(sourceModule, offset);
                            if (containerType == null) {
                                containerType = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                            }
                            if (FUNCTION.equalsIgnoreCase(prevWord)) {
                                if (containerType != null) {
                                    return PHPModelUtils.getTypeMethod(containerType, elementName, true);
                                }
                                return PHPSelectionEngine.getFunction(sourceModule, elementName);
                            }
                            if (CLASS.equalsIgnoreCase(prevWord) || INTERFACE.equalsIgnoreCase(prevWord)) {
                                if (containerType != null) {
                                    if (containerType.getElementName().equalsIgnoreCase(elementName)) {
                                        containerType = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                                    }
                                    if (containerType != null) {
                                        return PHPModelUtils.getTypeType(containerType, elementName, true);
                                    }
                                }
                                return PHPSelectionEngine.getClass(sourceModule, elementName);
                            }
                            if (NEW.equalsIgnoreCase(prevWord)) {
                                return PHPSelectionEngine.getConstructorsIfAny(PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(elementName, sourceModule, offset, null)));
                            }
                            isClassDeclaration = false;
                            if (statement.length() <= 6) break block40;
                            if (!CLASS.equals(statement.subSequence(0, 5).toString())) break block41;
                            isClassDeclaration = true;
                            if (true) break block42;
                        }
                        if (statement.length() <= 10 || !INTERFACE.equals(statement.subSequence(0, 9).toString())) break block40;
                    }
                    if ((generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, prevWord, elementName, offset)) != null) {
                        return generalizationTypes;
                    }
                    int listStartPosition = PHPTextSequenceUtilities.readIdentifierListStartIndex(statement, endPosition);
                    int preListWordEnd = PHPTextSequenceUtilities.readBackwardSpaces(statement, listStartPosition);
                    int preListWordStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statement, preListWordEnd, false);
                    String preListWord = statement.subSequence(preListWordStart, preListWordEnd).toString();
                    generalizationTypes = PHPSelectionEngine.getGeneralizationTypes(sourceModule, isClassDeclaration, preListWord, elementName, offset);
                    if (generalizationTypes != null) {
                        return generalizationTypes;
                    }
                }
                String trigger = null;
                if (startPosition > 2) {
                    trigger = statement.subSequence(startPosition - 2, startPosition).toString();
                }
                if (elementName.charAt(0) == '$' && !PAAMAYIM_NEKUDOTAIM.equals(trigger)) {
                    if (PHPPartitionTypes.isPHPQuotesState(tRegion.getType())) {
                        try {
                            char charBefore = sDoc.get(elementStart - 2, 1).charAt(0);
                            if (charBefore == '\\') {
                                return EMPTY;
                            }
                        }
                        catch (BadLocationException e) {
                            PHPCorePlugin.log(e);
                        }
                    }
                    if (containerType != null) {
                        if (VAR.equalsIgnoreCase(prevWord) || PRIVATE.equalsIgnoreCase(prevWord) || STATIC.equalsIgnoreCase(prevWord) || PUBLIC.equalsIgnoreCase(prevWord) || PROTECTED.equalsIgnoreCase(prevWord)) {
                            return PHPModelUtils.getTypeField(containerType, elementName, true);
                        }
                        if (THIS.equalsIgnoreCase(elementName)) {
                            return new IModelElement[]{containerType};
                        }
                    }
                    return PHPSelectionEngine.getGlobalOrMethodFields(sourceModule, offset, elementName);
                }
                if (containerType != null && CONST.equalsIgnoreCase(prevWord)) {
                    return PHPModelUtils.getTypeField(containerType, elementName, true);
                }
                if (PAAMAYIM_NEKUDOTAIM.equals(nextWord)) {
                    return PHPModelUtils.getTypes(elementName, sourceModule, offset, null);
                }
                if (NS_SEPARATOR.equals(nextWord)) {
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                    return PhpModelAccess.getDefault().findTypes(null, elementName, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null);
                }
                IType[] types = CodeAssistUtils.getTypesFor(sourceModule, statement, startPosition, offset);
                if (OPEN_BRACE.equals(nextWord) || PHPPartitionTypes.isPHPDocState(tRegion.getType())) {
                    if (types != null && types.length > 0) {
                        LinkedList<IMethod> methods = new LinkedList<IMethod>();
                        IType[] iTypeArray = types;
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType t = iTypeArray[n2];
                            methods.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyMethod(t, elementName, true, null)));
                            ++n2;
                        }
                        return (IModelElement[])methods.toArray(new IMethod[methods.size()]);
                    }
                    return PHPModelUtils.getFunctions(elementName, sourceModule, offset, null);
                }
                if (types != null && types.length > 0) {
                    if (startPosition > 0 && PAAMAYIM_NEKUDOTAIM.equals(trigger) && elementName.charAt(0) != '$') {
                        LinkedList fields = new LinkedList();
                        IType[] iTypeArray = types;
                        if (types.length != 0) {
                            IType t = iTypeArray[0];
                            return PHPModelUtils.getTypeField(t, elementName, true);
                        }
                        return fields.toArray(new IModelElement[fields.size()]);
                    }
                    TreeSet<IModelElement> fields = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

                        @Override
                        public int compare(IModelElement o1, IModelElement o2) {
                            try {
                                ISourceRange r1 = ((SourceRefElement)o1).getSourceRange();
                                ISourceRange r2 = ((SourceRefElement)o2).getSourceRange();
                                return (int)Math.signum(r1.getOffset() - r2.getOffset());
                            }
                            catch (ModelException e) {
                                PHPCorePlugin.log(e);
                                return 0;
                            }
                        }
                    });
                    IType[] iTypeArray = types;
                    int n = types.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IType t = iTypeArray[n3];
                        fields.addAll(Arrays.asList(PHPModelUtils.getTypeHierarchyField(t, elementName, true, null)));
                        ++n3;
                    }
                    return fields.toArray(new IModelElement[fields.size()]);
                }
                IField[] fields = PHPModelUtils.getFields(elementName, sourceModule, offset, null);
                if (fields != null && fields.length > 0) {
                    return fields;
                }
                return PHPModelUtils.getTypes(elementName, sourceModule, offset, null);
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
        }
        return EMPTY;
    }

    private static IModelElement[] getGeneralizationTypes(org.eclipse.dltk.core.ISourceModule sourceModule, boolean isClassDeclaration, String generalization, String elementName, int offset) throws ModelException {
        if (EXTENDS.equalsIgnoreCase(generalization)) {
            if (isClassDeclaration) {
                return PHPSelectionEngine.extractClasses(PHPModelUtils.getTypes(elementName, sourceModule, offset, null));
            }
            return PHPSelectionEngine.extractInterfaces(PHPModelUtils.getTypes(elementName, sourceModule, offset, null));
        }
        if (IMPLEMENTS.equalsIgnoreCase(generalization)) {
            return PHPSelectionEngine.extractInterfaces(PHPModelUtils.getTypes(elementName, sourceModule, offset, null));
        }
        return null;
    }

    private static IModelElement[] getFunction(org.eclipse.dltk.core.ISourceModule sourceModule, String elementName) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = ((AbstractSourceModule)sourceModule).getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{method};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IModelElement[] getClass(org.eclipse.dltk.core.ISourceModule sourceModule, String elementName) throws ModelException {
        IType[] types;
        IType[] iTypeArray = types = sourceModule.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getElementName().equalsIgnoreCase(elementName)) {
                return new IModelElement[]{type};
            }
            ++n2;
        }
        return EMPTY;
    }

    private static IType[] extractInterfaces(IType[] types) {
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                if (PHPFlags.isInterface((int)type.getFlags())) {
                    result.add(type);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] extractClasses(IType[] types) {
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                if (PHPFlags.isClass(type.getFlags())) {
                    result.add(type);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IModelElement[] getConstructorsIfAny(IType[] types) throws ModelException {
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            boolean hasConstructor = false;
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                if (method.isConstructor()) {
                    result.add(method);
                    hasConstructor = true;
                    break;
                }
                ++n4;
            }
            if (!hasConstructor) {
                result.add(type);
            }
            ++n2;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private static IModelElement[] getGlobalOrMethodFields(org.eclipse.dltk.core.ISourceModule sourceModule, int offset, String prefix) throws ModelException {
        try {
            IModelElement enclosingElement = sourceModule.getElementAt(offset);
            if (enclosingElement instanceof IField) {
                enclosingElement = enclosingElement.getParent();
            }
            if (enclosingElement instanceof IMethod) {
                IMethod method = (IMethod)enclosingElement;
                return PHPModelUtils.getMethodFields(method, prefix, true, null);
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return PHPModelUtils.getFields(prefix, sourceModule, offset, null);
    }
}

