/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class ClassMemberContext
extends StatementContext {
    private Trigger triggerType;
    private IType[] types;
    private int elementStart;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        int totalLength = statementText.length();
        this.elementStart = PHPTextSequenceUtilities.readBackwardSpaces(statementText, totalLength);
        this.elementStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, this.elementStart, true);
        this.elementStart = PHPTextSequenceUtilities.readBackwardSpaces(statementText, this.elementStart);
        if (this.elementStart <= 2) {
            return false;
        }
        String triggerText = statementText.subSequence(this.elementStart - 2, this.elementStart).toString();
        if (triggerText.equals("->")) {
            this.triggerType = Trigger.OBJECT;
        } else if (triggerText.equals("::")) {
            this.triggerType = Trigger.CLASS;
        } else {
            return false;
        }
        this.types = this.getCompanion().getLeftHandType(this);
        return true;
    }

    public int getElementStart() {
        return this.elementStart;
    }

    public IType[] getLhsTypes() {
        return this.types;
    }

    public Trigger getTriggerType() {
        return this.triggerType;
    }

    public int getPrefixEnd() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        if (phpToken.getType() == "PHP_OBJECT_OPERATOR" || phpToken.getType() == "PHP_PAAMAYIM_NEKUDOTAYIM") {
            IPhpScriptRegion phpScriptRegion = this.getPhpScriptRegion();
            ITextRegion nextRegion = phpScriptRegion.getPhpToken(phpToken.getEnd());
            if (phpToken.getTextLength() == phpToken.getLength()) {
                return this.getRegionCollection().getStartOffset() + phpScriptRegion.getStart() + nextRegion.getTextEnd();
            }
        }
        return super.getPrefixEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Trigger {
        CLASS("::"),
        OBJECT("->");

        String name;

        private Trigger(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

