/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMembersStrategy;
import org.eclipse.php.internal.core.language.PHPMagicMethods;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class ClassMethodsStrategy
extends ClassMembersStrategy {
    public ClassMethodsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassMethodsStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof ClassMemberContext)) {
            return;
        }
        ClassMemberContext concreteContext = (ClassMemberContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        String prefix = concreteContext.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(concreteContext);
        boolean isParentCall = this.isParentCall(concreteContext);
        String suffix = this.getSuffix(concreteContext);
        PHPVersion phpVersion = concreteContext.getPhpVersion();
        HashSet<String> magicMethods = new HashSet<String>();
        magicMethods.addAll(Arrays.asList(PHPMagicMethods.getMethods(phpVersion)));
        boolean exactName = requestor.isContextInformationMode();
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = concreteContext.getLhsTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(type, null);
                IMethod[] methods = isParentCall ? PHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, prefix, exactName, null) : PHPModelUtils.getTypeHierarchyMethod(type, hierarchy, prefix, exactName, null);
                for (IMethod method : this.removeOverriddenElements(Arrays.asList(methods))) {
                    if (magicMethods.contains(method.getElementName()) || this.isFiltered((IMember)method, concreteContext)) continue;
                    result.add(method);
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        for (IMethod method : result) {
            reporter.reportMethod(method, suffix, replaceRange);
        }
    }

    protected boolean showNonStaticMembers(ClassMemberContext context) {
        return super.showNonStaticMembers(context) || context.getTriggerType() == ClassMemberContext.Trigger.CLASS;
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "(".equals(nextWord) ? "" : "()";
    }
}

