/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.ArchiveFolder;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.IncludeStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.core.phar.PharPath;

public class IncludeStatementStrategy
extends AbstractCompletionStrategy {
    public static final String FOLDER_SEPARATOR = "/";

    public IncludeStatementStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws Exception {
        IncludePath[] includePaths;
        ICompletionContext context = this.getContext();
        if (!(context instanceof IncludeStatementContext)) {
            return;
        }
        IncludeStatementContext includeContext = (IncludeStatementContext)context;
        String prefix = includeContext.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(includeContext);
        ISourceModule sourceModule = includeContext.getSourceModule();
        if (sourceModule == null || sourceModule.getScriptProject() == null) {
            if (DLTKCore.DEBUG_COMPLETION) {
                System.out.println("Unable to locate source module or project");
            }
            return;
        }
        IScriptProject scriptProject = sourceModule.getScriptProject();
        IncludePath[] includePathArray = includePaths = IncludePathManager.getInstance().getIncludePaths(scriptProject.getProject());
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IncludePath includePath = includePathArray[n2];
            this.visitEntry(includePath, prefix, reporter, replaceRange, sourceModule.getScriptProject());
            ++n2;
        }
    }

    private void visitEntry(IncludePath includePath, String prefix, ICompletionReporter reporter, SourceRange replaceRange, IScriptProject project) {
        Path prefixPath;
        Object entry = includePath.getEntry();
        Path prefixPathFolder = prefixPath = new Path(prefix);
        Path lastSegmant = new Path("");
        if (prefixPath.segmentCount() != 0 && !prefix.endsWith("\\") && !prefix.endsWith(FOLDER_SEPARATOR)) {
            prefixPathFolder = prefixPath.removeLastSegments(1);
            lastSegmant = new Path(prefixPath.lastSegment());
        }
        try {
            if (!includePath.isBuildpath()) {
                this.addInternalEntries(reporter, replaceRange, entry, (IPath)prefixPathFolder, (IPath)lastSegmant);
            } else {
                this.addExternalEntries(reporter, replaceRange, project, entry, (IPath)prefixPathFolder, (IPath)lastSegmant);
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addExternalEntries(ICompletionReporter reporter, SourceRange replaceRange, IScriptProject project, Object entry, IPath prefixPathFolder, IPath lastSegmant) throws ModelException {
        switch (((IBuildpathEntry)entry).getEntryKind()) {
            case 5: {
                var11_8 = findProjectFragments = project.findProjectFragments((IBuildpathEntry)entry);
                var10_10 = findProjectFragments.length;
                var9_13 = 0;
                while (var9_13 < var10_10) {
                    projectFragment = var11_8[var9_13];
                    var16_27 = children = projectFragment.getChildren();
                    var15_24 = ((IModelElement[])var16_27).length;
                    var14_21 = 0;
                    while (var14_21 < var15_24) {
                        element = var16_27[var14_21];
                        if (element instanceof ScriptFolder && (relative = ((ScriptFolder)element).getRelativePath()).segmentCount() != 0 && this.isLastSegmantPrefix(lastSegmant, relative) && this.isPathPrefix(prefixPathFolder, relative)) {
                            reporter.reportResource(element, relative, this.getSuffix(element), replaceRange);
                        }
                        ++var14_21;
                    }
                    scriptFolder = projectFragment.getScriptFolder(prefixPathFolder);
                    relative = children = scriptFolder.getChildren();
                    var16_26 = ((IModelElement[])relative).length;
                    var15_24 = 0;
                    while (var15_24 < var16_26) {
                        element = relative[var15_24];
                        relative = element.getPath().makeRelativeTo(projectFragment.getPath());
                        if (this.isLastSegmantPrefix(lastSegmant, relative)) {
                            reporter.reportResource((IModelElement)element, relative, this.getSuffix((IModelElement)element), replaceRange);
                        }
                        ++var15_24;
                    }
                    ++var9_13;
                }
                break;
            }
            case 2: {
                workspace = ResourcesPlugin.getWorkspace();
                refProject = (IProject)workspace.getRoot().findMember(((IBuildpathEntry)entry).getPath());
                try {
                    this.addInternalEntries(reporter, replaceRange, refProject, prefixPathFolder, lastSegmant);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                var14_23 = findProjectFragments1 = project.findProjectFragments((IBuildpathEntry)entry);
                var13_20 = findProjectFragments1.length;
                var12_18 = 0;
                while (var12_18 < var13_20) {
                    projectFragment = var14_23[var12_18];
                    if (!(projectFragment instanceof ArchiveProjectFragment)) ** GOTO lbl95
                    apf = (ArchiveProjectFragment)projectFragment;
                    path = apf.getPath();
                    external = false;
                    if (EnvironmentPathUtils.isFull((IPath)path)) {
                        path = EnvironmentPathUtils.getLocalPath((IPath)path);
                        external = true;
                    }
                    pharPath = null;
                    pharPath = external != false ? new Path("phar://" + path.toString()) : new Path("phar:/" + path.toString());
                    if (prefixPathFolder.segmentCount() != 0) ** GOTO lbl59
                    if (external) {
                        reporter.reportResource((IModelElement)apf, (IPath)pharPath, "", replaceRange);
                    }
                    ** GOTO lbl95
lbl59:
                    // 1 sources

                    if (!"phar:".equals(prefixPathFolder.getDevice())) ** GOTO lbl95
                    if (!external) ** GOTO lbl63
                    if (pharPath.isPrefixOf(prefixPathFolder.append(lastSegmant))) ** GOTO lbl67
                    ** GOTO lbl95
lbl63:
                    // 1 sources

                    pp = PharPath.getPharPath(prefixPathFolder.append(lastSegmant));
                    if (pp == null || !new Path(pp.getPharName()).lastSegment().equals(pharPath.lastSegment())) ** GOTO lbl95
                    index = prefixPathFolder.append(lastSegmant).toString().indexOf(pharPath.lastSegment());
                    pharPath = new Path(prefixPathFolder.append(lastSegmant).toString().substring(0, index + pharPath.lastSegment().length()));
lbl67:
                    // 2 sources

                    var23_42 = children = projectFragment.getChildren();
                    var22_39 = children.length;
                    var21_38 = 0;
                    while (var21_38 < var22_39) {
                        element = var23_42[var21_38];
                        if (element instanceof ArchiveFolder) {
                            relative = ((ArchiveFolder)element).getRelativePath();
                            tempPrefixPathFolder = prefixPathFolder;
                            isLastSegmantPrefix = this.isLastSegmantPrefix(lastSegmant, relative);
                            if (lastSegmant.toString().endsWith(".phar")) {
                                isLastSegmantPrefix = true;
                                tempPrefixPathFolder = prefixPathFolder.append(lastSegmant);
                            }
                            fullPath = pharPath.append(relative);
                            if (relative.segmentCount() != 0 && !relative.toString().equals(".phar") && isLastSegmantPrefix && this.isPathPrefix(tempPrefixPathFolder, fullPath)) {
                                reporter.reportResource(element, fullPath, "/", replaceRange);
                            }
                        }
                        ++var21_38;
                    }
                    tempPrefixPathFolder = prefixPathFolder.append(lastSegmant);
                    scriptFolder = projectFragment.getScriptFolder(tempPrefixPathFolder.removeFirstSegments(pharPath.segmentCount()).setDevice(null));
                    var25_45 = children = scriptFolder.getChildren();
                    var24_43 = children.length;
                    var23_41 = 0;
                    while (var23_41 < var24_43) {
                        element = var25_45[var23_41];
                        relative = tempPrefixPathFolder.append(element.getElementName());
                        reporter.reportResource(element, relative, this.getSuffix(element), replaceRange);
                        ++var23_41;
                    }
lbl95:
                    // 6 sources

                    ++var12_18;
                }
                break;
            }
        }
    }

    private void addInternalEntries(ICompletionReporter reporter, SourceRange replaceRange, Object entry, IPath prefixPathFolder, IPath lastSegmant) throws CoreException {
        IResource[] members;
        IContainer container = (IContainer)entry;
        if (prefixPathFolder.segmentCount() > 0) {
            container = container.getFolder(prefixPathFolder);
        }
        if (!container.exists()) {
            return;
        }
        ICompletionContext context = this.getContext();
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IPath relative = resource.getFullPath().makeRelativeTo(container.getFullPath());
            if (this.isLastSegmantPrefix(lastSegmant, relative)) {
                IPath rel = resource.getFullPath().makeRelativeTo(((IContainer)entry).getFullPath());
                IModelElement modelElement = DLTKCore.create((IResource)resource);
                if (modelElement != null) {
                    if (resource.getType() == 1) {
                        if (PHPToolkitUtil.isPhpFile((IFile)resource) && !modelElement.equals(((IncludeStatementContext)context).getSourceModule())) {
                            reporter.reportResource(modelElement, rel, this.getSuffix(modelElement), replaceRange);
                        }
                    } else if (resource.getName().charAt(0) != '.') {
                        reporter.reportResource(modelElement, rel, this.getSuffix(modelElement), replaceRange);
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isPathPrefix(IPath prefixPath, IPath path) {
        if (prefixPath.segmentCount() != path.segmentCount() - 1) {
            return false;
        }
        return prefixPath.isPrefixOf(path);
    }

    private boolean isLastSegmantPrefix(IPath prefixPath, IPath relative) {
        String lastCurrentSegment = relative.lastSegment();
        String lastPrefixSegment = prefixPath.lastSegment();
        if (lastCurrentSegment == null) {
            lastCurrentSegment = "";
        }
        if (lastPrefixSegment == null) {
            lastPrefixSegment = "";
        }
        return CodeAssistUtils.startsWithIgnoreCase(lastCurrentSegment, lastPrefixSegment);
    }

    public String getSuffix(IModelElement modelElement) {
        return modelElement.getElementType() == 5 ? "" : FOLDER_SEPARATOR;
    }
}

