/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalMethodStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class LocalMethodVariablesStrategy
extends GlobalElementStrategy {
    public LocalMethodVariablesStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public LocalMethodVariablesStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException, ModelException {
        IType declaringType;
        ICompletionContext context = this.getContext();
        if (!(context instanceof GlobalMethodStatementContext)) {
            return;
        }
        GlobalMethodStatementContext concreteContext = (GlobalMethodStatementContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        String prefix = concreteContext.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(context);
        IMethod enclosingMethod = concreteContext.getEnclosingMethod();
        if (!PHPFlags.isStatic((int)enclosingMethod.getFlags()) && (declaringType = enclosingMethod.getDeclaringType()) != null && "$this".startsWith(prefix)) {
            reporter.reportField((IField)new FakeField((ModelElement)declaringType, "$this", 0, 0), "->", replaceRange, false);
        }
        IModelElement[] iModelElementArray = PHPModelUtils.getMethodFields(enclosingMethod, prefix, requestor.isContextInformationMode(), null);
        int n = iModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            reporter.reportField((IField)element, "", replaceRange, false);
            ++n2;
        }
        PHPVersion phpVersion = concreteContext.getPhpVersion();
        String[] stringArray = PHPVariables.getVariables(phpVersion);
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String variable = stringArray[n];
            if (variable.startsWith(prefix) && (!requestor.isContextInformationMode() || variable.length() == prefix.length())) {
                reporter.reportField((IField)new FakeField((ModelElement)concreteContext.getSourceModule(), variable, 0, 0), "", replaceRange, false);
            }
            ++n;
        }
    }
}

