/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.filenetwork;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.model.IncludeField;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.util.PHPSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNetworkUtility {
    public static ReferenceTree buildReferencingFilesTree(ISourceModule file, IProgressMonitor monitor) {
        HashSet<ISourceModule> processedFiles = new HashSet<ISourceModule>();
        processedFiles.add(file);
        ReferenceTree.Node root = new ReferenceTree.Node(file);
        FileNetworkUtility.internalBuildReferencingFilesTree(root, processedFiles, new HashMap<IModelElement, IField[]>(), monitor);
        return new ReferenceTree(root);
    }

    private static IDLTKSearchScope createSearchScope(ISourceModule file) {
        if (LanguageModelInitializer.isLanguageModelElement((IModelElement)file)) {
            return null;
        }
        if (file instanceof ExternalSourceModule) {
            try {
                IScriptProject[] scriptProjects;
                IProjectFragment fileFragment = ((ExternalSourceModule)file).getProjectFragment();
                LinkedList<Object> scopeElements = new LinkedList<Object>();
                scopeElements.add(fileFragment);
                IScriptProject[] iScriptProjectArray = scriptProjects = ModelManager.getModelManager().getModel().getScriptProjects();
                int n = scriptProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IScriptProject scriptProject = iScriptProjectArray[n2];
                    IProjectFragment[] iProjectFragmentArray = scriptProject.getProjectFragments();
                    int n3 = iProjectFragmentArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProjectFragment fragment = iProjectFragmentArray[n4];
                        if (fragment.equals(fileFragment)) {
                            scopeElements.add(scriptProject);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return SearchEngine.createSearchScope((IModelElement[])scopeElements.toArray(new IModelElement[scopeElements.size()]), (int)1, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        IScriptProject scriptProject = file.getScriptProject();
        IProject[] referencingProjects = scriptProject.getProject().getReferencingProjects();
        ArrayList<IScriptProject> scopeProjects = new ArrayList<IScriptProject>();
        scopeProjects.add(scriptProject);
        IProject[] iProjectArray = referencingProjects;
        int n = referencingProjects.length;
        int n5 = 0;
        while (n5 < n) {
            IProject referencingProject = iProjectArray[n5];
            if (referencingProject.isAccessible()) {
                scopeProjects.add(DLTKCore.create((IProject)referencingProject));
            }
            ++n5;
        }
        return SearchEngine.createSearchScope((IModelElement[])scopeProjects.toArray(new IScriptProject[scopeProjects.size()]), (int)1, (IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
    }

    private static void internalBuildReferencingFilesTree(ReferenceTree.Node root, Set<ISourceModule> processedFiles, Map<IModelElement, IField[]> includesCache, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        ISourceModule file = root.getFile();
        IDLTKSearchScope scope = FileNetworkUtility.createSearchScope(file);
        if (scope == null) {
            return;
        }
        Object parentElement = file instanceof ExternalSourceModule ? ((ExternalSourceModule)file).getProjectFragment() : file.getScriptProject();
        IField[] includes = includesCache.get(parentElement);
        if (includes == null) {
            includes = PhpModelAccess.getDefault().findIncludes(null, ISearchEngine.MatchRule.PREFIX, scope, monitor);
            includesCache.put((IModelElement)parentElement, includes);
        }
        IField[] iFieldArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceModule referencingFile;
            ISourceModule testFile;
            String filePath;
            IField include = iFieldArray[n2];
            String lastSegment = filePath = ((IncludeField)include).getFilePath();
            int i = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            if (i > 0) {
                lastSegment = lastSegment.substring(i + 1);
            }
            if (lastSegment.equals(file.getElementName()) && file.equals(testFile = FileNetworkUtility.findSourceModule(referencingFile = include.getSourceModule(), filePath)) && !processedFiles.contains(referencingFile)) {
                processedFiles.add(referencingFile);
                ReferenceTree.Node node = new ReferenceTree.Node(referencingFile);
                root.addChild(node);
            }
            ++n2;
        }
        Collection<ReferenceTree.Node> children = root.getChildren();
        if (children != null) {
            for (ReferenceTree.Node child : children) {
                FileNetworkUtility.internalBuildReferencingFilesTree(child, processedFiles, includesCache, monitor);
            }
        }
    }

    public static ReferenceTree buildReferencedFilesTree(ISourceModule file, IProgressMonitor monitor) {
        return FileNetworkUtility.buildReferencedFilesTree(file, null, monitor);
    }

    public static ReferenceTree buildReferencedFilesTree(ISourceModule file, Map<ISourceModule, ReferenceTree.Node> cachedTrees, IProgressMonitor monitor) {
        ReferenceTree.Node root;
        HashSet<ISourceModule> processedFiles = new HashSet<ISourceModule>();
        processedFiles.add(file);
        if (cachedTrees == null || (root = cachedTrees.get(file)) == null) {
            root = new ReferenceTree.Node(file);
            try {
                FileNetworkUtility.internalBuildReferencedFilesTree(root, processedFiles, cachedTrees, monitor);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return new ReferenceTree(root);
    }

    private static void internalBuildReferencedFilesTree(ReferenceTree.Node root, Set<ISourceModule> processedFiles, Map<ISourceModule, ReferenceTree.Node> cachedTrees, IProgressMonitor monitor) throws CoreException {
        ISourceModule sourceModule = root.getFile();
        IField[] includes = PhpModelAccess.getDefault().findIncludes(null, ISearchEngine.MatchRule.PREFIX, SearchEngine.createSearchScope((IModelElement)sourceModule), monitor);
        LinkedList<ReferenceTree.Node> nodesToBuild = new LinkedList<ReferenceTree.Node>();
        IField[] iFieldArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            IField include = iFieldArray[n2];
            String filePath = ((IncludeField)include).getFilePath();
            ISourceModule testFile = FileNetworkUtility.findSourceModule(sourceModule, filePath);
            if (testFile != null && !processedFiles.contains(testFile)) {
                ReferenceTree.Node child;
                processedFiles.add(testFile);
                if (cachedTrees != null && (child = cachedTrees.get(testFile)) != null) {
                    root.addChild(child);
                } else {
                    child = new ReferenceTree.Node(testFile);
                    nodesToBuild.add(child);
                    root.addChild(child);
                    if (cachedTrees != null) {
                        cachedTrees.put(testFile, child);
                    }
                }
            }
            ++n2;
        }
        for (ReferenceTree.Node child : nodesToBuild) {
            FileNetworkUtility.internalBuildReferencedFilesTree(child, processedFiles, cachedTrees, monitor);
        }
    }

    public static ISourceModule findSourceModule(ISourceModule from, String path) {
        String currentScriptDir;
        ISourceModule sourceModule = null;
        IProject currentProject = from.getScriptProject().getProject();
        String currentWorkingDir = currentScriptDir = from.getParent().getPath().toString();
        PHPSearchEngine.Result<?, ?> result = PHPSearchEngine.getInstance().find(path, currentWorkingDir, currentScriptDir, currentProject);
        if (result instanceof PHPSearchEngine.ResourceResult) {
            PHPSearchEngine.ResourceResult resResult = (PHPSearchEngine.ResourceResult)result;
            IResource resource = (IResource)resResult.getFile();
            sourceModule = (ISourceModule)DLTKCore.create((IResource)resource);
        } else if (result instanceof PHPSearchEngine.IncludedFileResult) {
            PHPSearchEngine.IncludedFileResult incResult = (PHPSearchEngine.IncludedFileResult)result;
            IProjectFragment[] projectFragments = incResult.getProjectFragments();
            if (projectFragments != null) {
                String folderPath = "";
                String moduleName = path;
                int i = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
                if (i != -1) {
                    folderPath = path.substring(0, i);
                    moduleName = path.substring(i + 1);
                }
                IProjectFragment[] iProjectFragmentArray = projectFragments;
                int n = projectFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFragment projectFragment = iProjectFragmentArray[n2];
                    IScriptFolder scriptFolder = projectFragment.getScriptFolder(folderPath);
                    if (scriptFolder == null || (sourceModule = scriptFolder.getSourceModule(moduleName)) == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else if (result instanceof PHPSearchEngine.IncludedPharFileResult) {
            sourceModule = (ISourceModule)((PHPSearchEngine.IncludedPharFileResult)result).getFile();
        }
        return sourceModule;
    }
}

