/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.core.language.ILanguageModelProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.osgi.framework.Bundle;

class DefaultLanguageModelProvider
implements ILanguageModelProvider {
    private static final String LANGUAGE_LIBRARY_PATH = "$nl$/Resources/language/php";

    DefaultLanguageModelProvider() {
    }

    public IPath getPath(IScriptProject project) {
        try {
            return this.getContainerPath(project, ProjectOptions.getPhpVersion((IModelElement)project));
        }
        catch (Exception e) {
            Logger.logException(e);
            return null;
        }
    }

    private String getLanguageLibraryPath(IScriptProject project, PHPVersion phpVersion) {
        if (phpVersion == PHPVersion.PHP4) {
            return "$nl$/Resources/language/php4";
        }
        if (phpVersion == PHPVersion.PHP5) {
            return "$nl$/Resources/language/php5";
        }
        return "$nl$/Resources/language/php5.3";
    }

    private IPath getContainerPath(IScriptProject project, PHPVersion phpVersion) throws IOException {
        String libraryPath = this.getLanguageLibraryPath(project, phpVersion);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("$nl$", Platform.getNL());
        URL url = FileLocator.find((Bundle)PHPCorePlugin.getDefault().getBundle(), (IPath)new Path(libraryPath), map);
        URL resolved = FileLocator.resolve((URL)url);
        return Path.fromOSString((String)resolved.getFile());
    }
}

