/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.DeclarationSearcher;
import org.eclipse.php.internal.core.typeinference.FakeField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPModelUtils {
    public static String extractElementName(String element) {
        int i = element.lastIndexOf(92);
        if (i != -1) {
            element = element.substring(i + 1).trim();
        }
        return element;
    }

    public static String extractNamespaceName(String elementName, ISourceModule sourceModule, int offset) {
        int nsIndex;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        UsePart usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, elementName, offset);
        if (usePart != null && (elementName = usePart.getNamespace().getFullyQualifiedName()).charAt(0) != '\\') {
            elementName = String.valueOf('\\') + elementName;
        }
        boolean isGlobal = false;
        if (elementName.charAt(0) == '\\') {
            isGlobal = true;
        }
        if ((nsIndex = elementName.lastIndexOf(92)) != -1) {
            String namespace = elementName.substring(0, nsIndex);
            if (isGlobal && namespace.length() > 0) {
                namespace = namespace.substring(1);
            }
            if (!isGlobal) {
                if ("namespace".equalsIgnoreCase(namespace)) {
                    IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                    return currentNamespace.getElementName();
                }
                if (namespace.indexOf(92) == -1 && (usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, namespace, offset)) != null) {
                    return usePart.getNamespace().getFullyQualifiedName();
                }
                IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                if (currentNamespace != null) {
                    return currentNamespace.getElementName() + '\\' + namespace;
                }
            }
            return namespace;
        }
        return null;
    }

    public static <T extends IModelElement> Collection<T> fileNetworkFilter(ISourceModule sourceModule, Collection<T> elements) {
        return PHPModelUtils.fileNetworkFilter(sourceModule, elements, null);
    }

    public static <T extends IModelElement> Collection<T> fileNetworkFilter(ISourceModule sourceModule, Collection<T> elements, ReferenceTree referenceTree) {
        if (elements != null && elements.size() > 0) {
            LinkedList<T> filteredElements = new LinkedList<T>();
            for (IModelElement element : elements) {
                if (!sourceModule.equals(element.getOpenable())) continue;
                filteredElements.add(element);
            }
            if (filteredElements.size() == 0) {
                if (referenceTree == null) {
                    referenceTree = FileNetworkUtility.buildReferencedFilesTree(sourceModule, null);
                }
                for (IModelElement element : elements) {
                    if (!LanguageModelInitializer.isLanguageModelElement(element) && !referenceTree.find(((ModelElement)element).getSourceModule())) continue;
                    filteredElements.add(element);
                }
            }
            if (filteredElements.size() > 0) {
                elements = filteredElements;
            }
        }
        return elements;
    }

    private static <T extends IModelElement> boolean canUseFileNetworkFilter(Collection<T> elements) {
        int elementType = 0;
        String elementName = null;
        for (IModelElement element : elements) {
            if (elementName == null) {
                elementType = element.getElementType();
                elementName = element.getElementName();
                continue;
            }
            if (elementName.equalsIgnoreCase(element.getElementName()) && elementType == element.getElementType()) continue;
            return false;
        }
        return true;
    }

    public static <T extends IModelElement> Collection<T> filterElements(ISourceModule sourceModule, Collection<T> elements) {
        if (elements == null) {
            return null;
        }
        if (PHPModelUtils.canUseFileNetworkFilter(elements)) {
            return PHPModelUtils.fileNetworkFilter(sourceModule, elements);
        }
        return elements;
    }

    public static IMethod getCurrentMethod(ISourceModule sourceModule, int offset) {
        try {
            IModelElement currentMethod = sourceModule.getElementAt(offset);
            while (currentMethod != null) {
                if (currentMethod instanceof IMethod) {
                    return (IMethod)currentMethod;
                }
                if (currentMethod instanceof IField) {
                    currentMethod = currentMethod.getParent();
                    continue;
                }
                break;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespace(IModelElement element) {
        try {
            IModelElement currentNs = element;
            while (currentNs != null) {
                if (currentNs instanceof IType && PHPFlags.isNamespace(((IType)currentNs).getFlags())) {
                    return (IType)currentNs;
                }
                currentNs = currentNs.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespace(ISourceModule sourceModule, int offset) {
        try {
            IModelElement currentNs = sourceModule.getElementAt(offset);
            while (currentNs instanceof IField) {
                currentNs = sourceModule.getElementAt(((IField)currentNs).getSourceRange().getOffset() - 1);
            }
            while (currentNs != null) {
                if (currentNs instanceof IType && PHPFlags.isNamespace(((IType)currentNs).getFlags())) {
                    return (IType)currentNs;
                }
                currentNs = currentNs.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentType(IModelElement element) {
        try {
            while (element != null) {
                if (element instanceof IType) {
                    if (!PHPFlags.isNamespace(((IType)element).getFlags())) {
                        return (IType)element;
                    }
                    break;
                }
                element = element.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentType(ISourceModule sourceModule, int offset) {
        try {
            return PHPModelUtils.getCurrentType(sourceModule.getElementAt(offset));
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public static PHPDocBlock getDocBlock(IField field) {
        block4: {
            if (field == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = field.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                ASTNode fieldDeclaration = PHPModelUtils.getNodeByField(moduleDeclaration, field);
                if (fieldDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)fieldDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static PHPDocBlock getDocBlock(IMethod method) {
        block4: {
            if (method == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = method.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                MethodDeclaration methodDeclaration = PHPModelUtils.getNodeByMethod(moduleDeclaration, method);
                if (methodDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)methodDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static PHPDocBlock getDocBlock(IType type) {
        block4: {
            if (type == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = type.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass(moduleDeclaration, type);
                if (typeDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IField[] getFields(String fieldName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        if (fieldName == null || fieldName.length() == 0) {
            return null;
        }
        if (!fieldName.startsWith("$")) {
            String namespace = PHPModelUtils.extractNamespaceName(fieldName, sourceModule, offset);
            fieldName = PHPModelUtils.extractElementName(fieldName);
            if (namespace != null) {
                if (namespace.length() > 0) {
                    IField[] fields = PHPModelUtils.getNamespaceField(namespace, fieldName, true, sourceModule, monitor);
                    if (fields.length > 0) {
                        return fields;
                    }
                    return null;
                }
            } else {
                IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
                if (currentNamespace != null) {
                    namespace = currentNamespace.getElementName();
                    IField[] fields = PHPModelUtils.getNamespaceField(namespace, fieldName, true, sourceModule, monitor);
                    if (fields.length > 0) {
                        return fields;
                    }
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                    fields = PhpModelAccess.getDefault().findFields(fieldName, ISearchEngine.MatchRule.EXACT, 8194, 0, scope, null);
                    Collection<IField> filteredElements = PHPModelUtils.filterElements(sourceModule, Arrays.asList(fields));
                    return filteredElements.toArray(new IField[filteredElements.size()]);
                }
            }
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IField[] fields = PhpModelAccess.getDefault().findFields(fieldName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
        Collection<IField> filteredElements = PHPModelUtils.filterElements(sourceModule, Arrays.asList(fields));
        return filteredElements.toArray(new IField[filteredElements.size()]);
    }

    public static IMethod[] getFunctions(String functionName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        if (functionName == null || functionName.length() == 0) {
            return null;
        }
        String namespace = PHPModelUtils.extractNamespaceName(functionName, sourceModule, offset);
        functionName = PHPModelUtils.extractElementName(functionName);
        if (namespace != null) {
            if (namespace.length() > 0) {
                IMethod[] functions = PHPModelUtils.getNamespaceFunction(namespace, functionName, true, sourceModule, monitor);
                if (functions.length > 0) {
                    return functions;
                }
                return null;
            }
        } else {
            IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (currentNamespace != null) {
                namespace = currentNamespace.getElementName();
                IMethod[] functions = PHPModelUtils.getNamespaceFunction(namespace, functionName, true, sourceModule, monitor);
                if (functions.length > 0) {
                    return functions;
                }
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                functions = PhpModelAccess.getDefault().findMethods(functionName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
                Collection<IMethod> filteredElements = PHPModelUtils.filterElements(sourceModule, Arrays.asList(functions));
                return filteredElements.toArray(new IMethod[filteredElements.size()]);
            }
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IMethod[] functions = PhpModelAccess.getDefault().findMethods(functionName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
        Collection<IMethod> filteredElements = PHPModelUtils.filterElements(sourceModule, Arrays.asList(functions));
        return filteredElements.toArray(new IMethod[filteredElements.size()]);
    }

    public static IModelElement[] getMethodFields(final IMethod method, final String prefix, final boolean exactName, IProgressMonitor monitor) {
        final LinkedList<IField> elements = new LinkedList<IField>();
        final HashSet<String> processedVars = new HashSet<String>();
        try {
            IModelElement[] children;
            IModelElement[] iModelElementArray = children = method.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                if (child.getElementType() == 8) {
                    String elementName = child.getElementName();
                    if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                        elements.add((IField)child);
                        processedVars.add(elementName);
                    }
                }
                ++n2;
            }
            ModuleDeclaration rootNode = SourceParserUtil.getModuleDeclaration((ISourceModule)method.getSourceModule());
            MethodDeclaration methodDeclaration = PHPModelUtils.getNodeByMethod(rootNode, method);
            methodDeclaration.traverse(new ASTVisitor(){

                public boolean visit(Statement s) throws Exception {
                    if (s instanceof GlobalStatement) {
                        GlobalStatement globalStatement = (GlobalStatement)s;
                        for (Expression expression : globalStatement.getVariables()) {
                            VariableReference varReference;
                            String varName;
                            if (!(expression instanceof VariableReference) || processedVars.contains(varName = (varReference = (VariableReference)expression).getName()) || (!exactName || !varName.equalsIgnoreCase(prefix)) && (exactName || !varName.toLowerCase().startsWith(prefix.toLowerCase()))) continue;
                            elements.add(new FakeField((ModelElement)method, varName, expression.sourceStart(), expression.sourceEnd() - expression.sourceStart()));
                            processedVars.add(varName);
                        }
                    }
                    return super.visit(s);
                }
            });
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    public static IField[] getFileFields(ISourceModule sourceModule, String prefix, boolean exactName, IProgressMonitor monitor) {
        LinkedList<IField> elements = new LinkedList<IField>();
        try {
            IField[] sourceModuleFields;
            IField[] iFieldArray = sourceModuleFields = sourceModule.getFields();
            int n = sourceModuleFields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String elementName = field.getElementName();
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    elements.add(field);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return elements.toArray(new IField[elements.size()]);
    }

    public static IField[] getNamespaceField(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IType[] namespaces = PhpModelAccess.getDefault().findTypes(null, namespace, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, monitor);
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeField(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] getNamespaceFunction(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IType[] namespaces = PhpModelAccess.getDefault().findTypes(null, namespace, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, monitor);
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getNamespaceOf(String elementName, ISourceModule sourceModule, int offset) {
        String namespace = PHPModelUtils.extractNamespaceName(elementName, sourceModule, offset);
        if (namespace != null && namespace.length() > 0) {
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
            return PhpModelAccess.getDefault().findTypes(null, namespace, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null);
        }
        return null;
    }

    public static IType[] getNamespaceType(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IType[] namespaces = PhpModelAccess.getDefault().findTypes(null, namespace, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, monitor);
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeType(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    public static TypeDeclaration getNodeByClass(ModuleDeclaration rootNode, IType type) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)type, DeclarationSearcher.DeclarationType.CLASS);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return (TypeDeclaration)visitor.getResult();
    }

    public static ASTNode getNodeByElement(ModuleDeclaration rootNode, IModelElement element) throws ModelException {
        switch (element.getElementType()) {
            case 7: {
                return PHPModelUtils.getNodeByClass(rootNode, (IType)element);
            }
            case 9: {
                return PHPModelUtils.getNodeByMethod(rootNode, (IMethod)element);
            }
            case 8: {
                return PHPModelUtils.getNodeByField(rootNode, (IField)element);
            }
        }
        throw new IllegalArgumentException("Unsupported element type: " + element.getClass().getName());
    }

    public static ASTNode getNodeByField(ModuleDeclaration rootNode, IField field) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)field, DeclarationSearcher.DeclarationType.FIELD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return visitor.getResult();
    }

    public static MethodDeclaration getNodeByMethod(ModuleDeclaration rootNode, IMethod method) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)method, DeclarationSearcher.DeclarationType.METHOD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return (MethodDeclaration)visitor.getResult();
    }

    public static IType[] getSuperClasses(IType type, ITypeHierarchy hierarchy) throws ModelException {
        if (hierarchy == null) {
            hierarchy = type.newSupertypeHierarchy(null);
        }
        Collection<IType> filtered = PHPModelUtils.filterElements(type.getSourceModule(), Arrays.asList(hierarchy.getAllSuperclasses(type)));
        return filtered.toArray(new IType[filtered.size()]);
    }

    public static IField[] getSuperTypeHierarchyField(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getSuperTypeHierarchyField(type, null, prefix, exactName, monitor);
    }

    public static IField[] getSuperTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        IType[] allSuperclasses = PHPModelUtils.getSuperClasses(type, hierarchy);
        return PHPModelUtils.getTypesField(allSuperclasses, prefix, exactName);
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getSuperTypeHierarchyMethod(type, null, prefix, exactName, monitor);
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        IType[] allSuperclasses = PHPModelUtils.getSuperClasses(type, hierarchy);
        return PHPModelUtils.getTypesMethod(allSuperclasses, prefix, exactName);
    }

    public static IField[] getTypeField(IType type, String prefix, boolean exactName) throws ModelException {
        IField[] fields;
        LinkedList<IField> result = new LinkedList<IField>();
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            String elementName = field.getElementName();
            if (elementName.startsWith("$") && !prefix.startsWith("$")) {
                elementName = elementName.substring(1);
            }
            if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                result.add(field);
            }
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IField[] getTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IField> fields = new LinkedList<IField>();
        fields.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            fields.addAll(Arrays.asList(PHPModelUtils.getSuperTypeHierarchyField(type, hierarchy, prefix, exactName, monitor)));
        }
        return fields.toArray(new IField[fields.size()]);
    }

    public static IField[] getTypeHierarchyField(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getTypeHierarchyField(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyFieldDoc(IType type, String name, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (name == null) {
            throw new NullPointerException();
        }
        LinkedList<PHPDocBlock> docs = new LinkedList<PHPDocBlock>();
        IField[] iFieldArray = PHPModelUtils.getTypeHierarchyField(type, name, exactName, monitor);
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            PHPDocBlock docBlock = PHPModelUtils.getDocBlock(field);
            if (docBlock != null) {
                docs.add(docBlock);
            }
            ++n2;
        }
        return docs.toArray(new PHPDocBlock[docs.size()]);
    }

    public static IMethod[] getTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        methods.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            methods.addAll(Arrays.asList(PHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, prefix, exactName, monitor)));
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IMethod[] getTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return PHPModelUtils.getTypeHierarchyMethod(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyMethodDoc(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<PHPDocBlock> docs = new LinkedList<PHPDocBlock>();
        IMethod[] iMethodArray = PHPModelUtils.getTypeHierarchyMethod(type, prefix, exactName, monitor);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
            if (docBlock != null) {
                docs.add(docBlock);
            }
            ++n2;
        }
        return docs.toArray(new PHPDocBlock[docs.size()]);
    }

    public static IMethod[] getTypeMethod(IType type, String prefix, boolean exactName) throws ModelException {
        IMethod[] methods;
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String elementName = method.getElementName();
            if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                result.add(method);
            }
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        IType[] types;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        String namespace = PHPModelUtils.extractNamespaceName(typeName, sourceModule, offset);
        typeName = PHPModelUtils.extractElementName(typeName);
        if (namespace != null) {
            if (namespace.length() > 0) {
                IType[] types2 = PHPModelUtils.getNamespaceType(namespace, typeName, true, sourceModule, monitor);
                if (types2.length > 0) {
                    return types2;
                }
                return null;
            }
        } else {
            IType currentNamespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (currentNamespace != null && (types = PHPModelUtils.getNamespaceType(namespace = currentNamespace.getElementName(), typeName, true, sourceModule, monitor)).length > 0) {
                return types;
            }
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        types = PhpModelAccess.getDefault().findTypes(typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (PHPModelUtils.getCurrentNamespace((IModelElement)type) == null) {
                result.add(type);
            }
            ++n2;
        }
        Collection filteredElements = PHPModelUtils.filterElements(sourceModule, result);
        return filteredElements.toArray(new IType[filteredElements.size()]);
    }

    public static IField[] getTypesField(IType[] types, String prefix, boolean exactName) throws ModelException {
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeField(type, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] getTypesMethod(IType[] types, String prefix, boolean exactName) throws ModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(Arrays.asList(PHPModelUtils.getTypeMethod(type, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getTypeType(IType type, String prefix, boolean exactName) throws ModelException {
        IType[] types;
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = types = type.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            String elementName = t.getElementName();
            if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                result.add(t);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IMethod[] getUnimplementedMethods(IType type, IProgressMonitor monitor) throws ModelException {
        return PHPModelUtils.getUnimplementedMethods(type, null, monitor);
    }

    public static IMethod[] getUnimplementedMethods(IType type, ReferenceTree referenceTree, IProgressMonitor monitor) throws ModelException {
        HashMap<String, IMethod> abstractMethods = new HashMap<String, IMethod>();
        HashSet<String> nonAbstractMethods = new HashSet<String>();
        PHPModelUtils.internalGetUnimplementedMethods(type, nonAbstractMethods, abstractMethods, new HashSet<String>(), referenceTree, monitor);
        for (String methodName : nonAbstractMethods) {
            abstractMethods.remove(methodName);
        }
        Collection<IMethod> unimplementedMethods = abstractMethods.values();
        return unimplementedMethods.toArray(new IMethod[unimplementedMethods.size()]);
    }

    private static void internalGetUnimplementedMethods(IType type, HashSet<String> nonAbstractMethods, HashMap<String, IMethod> abstractMethods, Set<String> processedTypes, ReferenceTree referenceTree, IProgressMonitor monitor) throws ModelException {
        int typeFlags = type.getFlags();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String methodName = method.getElementName();
            int methodFlags = method.getFlags();
            boolean isAbstract = PHPFlags.isAbstract((int)methodFlags);
            if (isAbstract || PHPFlags.isInterface((int)typeFlags)) {
                if (!abstractMethods.containsKey(methodName)) {
                    abstractMethods.put(methodName, method);
                }
            } else if (!isAbstract) {
                nonAbstractMethods.add(methodName);
            }
            ++n2;
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getScriptProject());
        String[] superClasses = type.getSuperClasses();
        if (superClasses != null) {
            String[] stringArray = superClasses;
            int n3 = superClasses.length;
            int n4 = 0;
            while (n4 < n3) {
                String superClass = stringArray[n4];
                if (processedTypes.add(superClass)) {
                    IType[] superTypes = PhpModelAccess.getDefault().findTypes(superClass, ISearchEngine.MatchRule.EXACT, 0, 2048, scope, null);
                    Collection<IType> filteredTypes = PHPModelUtils.fileNetworkFilter(type.getSourceModule(), Arrays.asList(superTypes), referenceTree);
                    for (IType superType : filteredTypes) {
                        PHPModelUtils.internalGetUnimplementedMethods(superType, nonAbstractMethods, abstractMethods, processedTypes, referenceTree, monitor);
                    }
                }
                ++n4;
            }
        }
    }
}

