/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
            if (docBlock != null) {
                IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
                PHPDocTag[] pHPDocTagArray = docBlock.getTags();
                int n3 = pHPDocTagArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    PHPDocTag tag = pHPDocTagArray[n4];
                    if (tag.getTagKind() == 6) {
                        SimpleReference[] simpleReferenceArray = tag.getReferences();
                        int n5 = simpleReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String[] typesNames;
                            SimpleReference reference = simpleReferenceArray[n6];
                            String[] stringArray = typesNames = PIPE_PATTERN.split(reference.getName());
                            int n7 = typesNames.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String typeName = stringArray[n8];
                                Object type = PHPSimpleTypes.fromString(typeName);
                                if (type == null) {
                                    if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                                        type = new PHPClassType(typeName);
                                    } else if (currentNamespace != null) {
                                        type = new PHPClassType(currentNamespace.getElementName(), typeName);
                                    }
                                }
                                if (type != null) {
                                    this.evaluated.add((IEvaluatedType)type);
                                }
                                ++n8;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

