/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.core.file;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.eclipse.ptp.utils.core.file.FileEnumeration;

public class FileRecursiveEnumeration
implements Enumeration {
    Stack roots;
    FileEnumeration currentDirectory;
    File nextFile;
    LinkedList exceptionList = new LinkedList();

    public FileRecursiveEnumeration(String root) {
        this(new File(root));
    }

    public FileRecursiveEnumeration(File root) {
        if (!root.exists()) {
            throw new IllegalArgumentException();
        }
        this.roots = new Stack();
        this.roots.add(root);
        this.fetchNextFile();
    }

    private void fetchNextFile() {
        this.nextFile = null;
        while (true) {
            if (this.currentDirectory == null) {
                if (this.roots.empty()) {
                    return;
                }
                File root = (File)this.roots.pop();
                try {
                    this.currentDirectory = new FileEnumeration(root);
                }
                catch (IOException e) {
                    this.exceptionList.addLast(e);
                }
                continue;
            }
            if (this.currentDirectory.hasMoreElements()) {
                this.nextFile = (File)this.currentDirectory.nextElement();
                if (this.nextFile.isDirectory()) {
                    this.roots.add(this.nextFile);
                }
                return;
            }
            this.currentDirectory = null;
        }
    }

    public boolean hasMoreExceptions() {
        return this.exceptionList.size() > 0;
    }

    public Exception nextException() {
        if (this.exceptionList.size() == 0) {
            throw new NoSuchElementException();
        }
        return (Exception)this.exceptionList.removeFirst();
    }

    public boolean hasMoreElements() {
        return this.nextFile != null;
    }

    public Object nextElement() {
        File result = this.nextFile;
        this.fetchNextFile();
        return result;
    }

    public static void main(String[] args) {
        FileRecursiveEnumeration enumeration = new FileRecursiveEnumeration("c:/command/gs");
        while (enumeration.hasMoreElements()) {
        }
    }
}

