/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ProblemsLabelDecorator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.ptp.internal.rdt.ui.editor.CEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class CEditorErrorTickUpdater
implements IProblemChangedListener {
    protected CEditor fCEditor;
    private CUILabelProvider fLabelProvider;

    public CEditorErrorTickUpdater(CEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.fCEditor = editor;
        this.fLabelProvider = new CEditorImageProvider();
        this.fLabelProvider.addLabelDecorator((ILabelDecorator)new ProblemsLabelDecorator(null));
        CUIPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void problemsChanged(IResource[] resourcesChanged, boolean isMarkerChange) {
        ICElement celement;
        if (isMarkerChange) {
            return;
        }
        IEditorInput input = this.fCEditor.getEditorInput();
        if (input != null && (celement = (ICElement)input.getAdapter(ICElement.class)) != null) {
            IResource resource = celement.getResource();
            if (resource == null) {
                return;
            }
            int i = 0;
            while (i < resourcesChanged.length) {
                if (resource.equals((Object)resourcesChanged[i])) {
                    this.updateEditorImage(celement);
                    return;
                }
                ++i;
            }
        }
    }

    public void updateEditorImage(ICElement celement) {
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fCEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    CEditorErrorTickUpdater.this.fCEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        CUIPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }

    private static class CEditorImageProvider
    extends CUILabelProvider {
        CEditorImageProvider() {
            super(0, 2);
        }

        protected int evaluateImageFlags(Object element) {
            ITranslationUnit tUnit;
            int flags = this.getImageFlags();
            if (element instanceof ITranslationUnit && (tUnit = (ITranslationUnit)element).getResource() == null) {
                flags |= 0x80;
            }
            return flags;
        }
    }
}

