/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import org.eclipse.cdt.internal.ui.LineBackgroundPainter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.internal.rdt.ui.editor.CEditor;
import org.eclipse.ptp.internal.rdt.ui.editor.InactiveCodeHighlighting;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CSourceViewerDecorationSupport
extends SourceViewerDecorationSupport {
    private static final String INACTIVE_CODE_KEY = "inactiveCode";
    private String fInactiveCodeColorKey;
    private String fInactiveCodeEnableKey;
    private LineBackgroundPainter fLineBackgroundPainter;
    private ISharedTextColors fSharedColors;
    private IPreferenceStore fPrefStore;
    private String fCLPColorKey;
    private String fCLPEnableKey;
    protected ISourceViewer fViewer;
    private CEditor fEditor;
    private InactiveCodeHighlighting fInactiveCodeHighlighting;

    CSourceViewerDecorationSupport(CEditor editor, ISourceViewer sourceViewer, IOverviewRuler overviewRuler, IAnnotationAccess annotationAccess, ISharedTextColors sharedTextColors) {
        super(sourceViewer, overviewRuler, annotationAccess, sharedTextColors);
        this.fEditor = editor;
        this.fViewer = sourceViewer;
        this.fSharedColors = sharedTextColors;
    }

    public void dispose() {
        super.dispose();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.equals(this.fCLPEnableKey)) {
            if (this.isCLPActive()) {
                this.showCLP();
            } else {
                this.hideCLP();
            }
        } else if (p.equals(this.fCLPColorKey)) {
            this.updateCLPColor();
        } else if (p.equals(this.fInactiveCodeEnableKey)) {
            if (this.isInactiveCodePositionsActive()) {
                this.showInactiveCodePositions(true);
            } else {
                this.hideInactiveCodePositions();
            }
        } else if (p.equals(this.fInactiveCodeColorKey)) {
            this.updateInactiveCodeColor();
        }
        super.handlePreferenceStoreChanged(event);
    }

    private void updateInactiveCodeColor() {
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.setBackgroundColor(INACTIVE_CODE_KEY, this.getColor(this.fInactiveCodeColorKey));
            if (this.isInactiveCodePositionsActive()) {
                this.fLineBackgroundPainter.redraw();
            }
        }
    }

    private void updateCLPColor() {
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.setCursorLineColor(this.getColor(this.fCLPColorKey));
            if (this.isCLPActive()) {
                this.fLineBackgroundPainter.redraw();
            }
        }
    }

    private void hideCLP() {
        if (this.fLineBackgroundPainter != null) {
            if (!this.isInactiveCodePositionsActive()) {
                this.uninstallLineBackgroundPainter();
            } else {
                this.fLineBackgroundPainter.enableCursorLine(false);
                this.fLineBackgroundPainter.redraw();
            }
        }
    }

    private void showCLP() {
        this.installLineBackgroundPainter();
        if (this.fLineBackgroundPainter != null) {
            this.fLineBackgroundPainter.enableCursorLine(true);
            this.fLineBackgroundPainter.redraw();
        }
    }

    private boolean isCLPActive() {
        if (this.fPrefStore != null) {
            return this.fPrefStore.getBoolean(this.fCLPEnableKey);
        }
        return false;
    }

    private boolean isInactiveCodePositionsActive() {
        if (this.fPrefStore != null) {
            return this.fPrefStore.getBoolean(this.fInactiveCodeEnableKey);
        }
        return false;
    }

    private Color getColor(String key) {
        if (this.fPrefStore != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPrefStore, (String)key);
            return this.getColor(rgb);
        }
        return null;
    }

    private Color getColor(RGB rgb) {
        return this.fSharedColors.getColor(rgb);
    }

    public void install(IPreferenceStore store) {
        super.install(store);
        this.fPrefStore = store;
        if (this.isCLPActive()) {
            this.showCLP();
        }
        if (this.isInactiveCodePositionsActive()) {
            this.showInactiveCodePositions(false);
        }
    }

    public void uninstall() {
        this.uninstallLineBackgroundPainter();
        super.uninstall();
    }

    private void installLineBackgroundPainter() {
        if (this.fLineBackgroundPainter == null && this.fViewer instanceof ITextViewerExtension2) {
            this.fLineBackgroundPainter = new LineBackgroundPainter((ITextViewer)this.fViewer);
            this.fLineBackgroundPainter.setBackgroundColor(INACTIVE_CODE_KEY, this.getColor(this.fInactiveCodeColorKey));
            this.fLineBackgroundPainter.setCursorLineColor(this.getColor(this.fCLPColorKey));
            this.fLineBackgroundPainter.enableCursorLine(this.isCLPActive());
            ((ITextViewerExtension2)this.fViewer).addPainter((IPainter)this.fLineBackgroundPainter);
        }
    }

    private void uninstallLineBackgroundPainter() {
        if (this.fLineBackgroundPainter != null) {
            if (this.fInactiveCodeHighlighting != null) {
                this.fInactiveCodeHighlighting.uninstall();
                this.fInactiveCodeHighlighting = null;
            }
            if (this.fViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)this.fViewer).removePainter((IPainter)this.fLineBackgroundPainter);
            }
            this.fLineBackgroundPainter.deactivate(true);
            this.fLineBackgroundPainter.dispose();
            this.fLineBackgroundPainter = null;
        }
    }

    private void showInactiveCodePositions(boolean refresh) {
        this.installLineBackgroundPainter();
        if (this.fLineBackgroundPainter != null) {
            this.fInactiveCodeHighlighting = new InactiveCodeHighlighting(INACTIVE_CODE_KEY);
            this.fInactiveCodeHighlighting.install(this.fEditor, this.fLineBackgroundPainter);
            if (refresh) {
                this.fInactiveCodeHighlighting.refresh();
            }
        }
    }

    private void hideInactiveCodePositions() {
        if (this.fLineBackgroundPainter != null) {
            if (this.fInactiveCodeHighlighting != null) {
                this.fInactiveCodeHighlighting.uninstall();
                this.fInactiveCodeHighlighting = null;
            }
            if (!this.isCLPActive()) {
                this.uninstallLineBackgroundPainter();
            }
        }
    }

    public void setCursorLinePainterPreferenceKeys(String enableKey, String colorKey) {
        this.fCLPEnableKey = enableKey;
        this.fCLPColorKey = colorKey;
        super.setCursorLinePainterPreferenceKeys(String.valueOf(enableKey) + "-overridden", colorKey);
    }

    public void setInactiveCodePainterPreferenceKeys(String enableKey, String colorKey) {
        this.fInactiveCodeEnableKey = enableKey;
        this.fInactiveCodeColorKey = colorKey;
    }
}

