/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search.actions;

import java.text.MessageFormat;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.internal.rdt.ui.editor.CEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionParseAction
extends Action {
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor editor) {
        this.fEditor = editor;
        this.fSite = editor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite site) {
        this.fSite = site;
    }

    public IWorkbenchSite getSite() {
        return this.fSite;
    }

    protected void showStatusLineMessage(String message) {
        StatusLineHandler.showStatusLineMessage((IWorkbenchSite)this.fSite, (String)message);
    }

    protected void clearStatusLine() {
        StatusLineHandler.clearStatusLine((IWorkbenchSite)this.fSite);
    }

    protected ISelection getSelection() {
        ISelection sel = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            sel = this.fSite.getSelectionProvider().getSelection();
        }
        return sel;
    }

    protected ITextSelection getSelectedStringFromEditor() {
        ISelection selection = this.getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    protected void open(IName name) throws CoreException {
        this.clearStatusLine();
        IASTFileLocation fileloc = name.getFileLocation();
        if (fileloc == null) {
            this.reportSymbolLookupFailure(new String(name.toCharArray()));
            return;
        }
        Path path = new Path(fileloc.getFileName());
        int currentOffset = fileloc.getNodeOffset();
        int currentLength = fileloc.getNodeLength();
        this.open((IPath)path, currentOffset, currentLength);
    }

    protected void open(IPath path, int currentOffset, int currentLength) throws CoreException {
        this.clearStatusLine();
        IEditorPart editor = EditorUtility.openInEditor((IPath)path, (ICElement)this.fEditor.getInputCElement());
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(currentOffset, currentLength);
        } else {
            this.reportSourceFileOpenFailure(path);
        }
    }

    protected void reportSourceFileOpenFailure(IPath path) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.SelectionParseAction_FileOpenFailure_format, path.toOSString()));
    }

    protected void reportSelectionMatchFailure() {
        this.showStatusLineMessage(CSearchMessages.SelectionParseAction_SelectedTextNotSymbol_message);
    }

    protected void reportSymbolLookupFailure(String symbol) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.SelectionParseAction_SymbolNotFoundInIndex_format, symbol));
    }

    protected void reportIncludeLookupFailure(String filename) {
        this.showStatusLineMessage(MessageFormat.format(CSearchMessages.SelectionParseAction_IncludeNotFound_format, filename));
    }
}

