/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.wizards.ConfigureRemoteServices;
import org.eclipse.ptp.rdt.ui.wizards.ServiceModelWidget;
import org.eclipse.swt.widgets.TableItem;

public class PropertyPageServiceModelWidget
extends ServiceModelWidget {
    IProject fProject;

    public void updateServicesTable(IProject project) {
        this.fProviderIDToProviderMap = new HashMap();
        this.fServiceIDToSelectedProviderID = new HashMap();
        this.fProject = project;
        this.createTableContent(project);
    }

    protected void createTableContent(IProject project) {
        this.fTable.removeAll();
        if (project == null) {
            super.createTableContent(project);
        } else {
            ServiceModelManager serviceModelManager = ServiceModelManager.getInstance();
            ServiceConfiguration config = (ServiceConfiguration)serviceModelManager.getConfiguration(project, ConfigureRemoteServices.DEFAULT_CONFIG);
            Set services = config.getServices();
            for (IService service : services) {
                IServiceProvider provider = config.getServiceProvider(service);
                TableItem item = new TableItem(this.fTable, 0);
                item.setText(0, service.getName());
                item.setData("service-id", (Object)service);
                item.setText(1, provider.getName());
                item.setData("provider-id", (Object)provider);
                String configString = provider.getConfigurationString();
                if (configString == null) {
                    configString = Messages.getString("ServiceModelWidget.4");
                }
                item.setText(2, configString);
                this.fServiceIDToSelectedProviderID.put(service.getId(), provider.getId());
                this.fProviderIDToProviderMap.put(provider.getId(), provider);
                if (this.fConfigChangeListener == null) continue;
                this.fConfigChangeListener.handleEvent(null);
            }
        }
    }

    public boolean isConfigured() {
        return this.isConfigured(this.fProject, this.fServiceIDToSelectedProviderID, this.fProviderIDToProviderMap);
    }
}

