/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.subsystems;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.rdt.core.RDTLog;

public class ProjectChangeListener
implements IResourceChangeListener {
    private IProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private ICIndexSubsystem fSubsystem;

    public ProjectChangeListener(ICIndexSubsystem subsystem) {
        this.fSubsystem = subsystem;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IProject) {
                        IProject project = (IProject)resource;
                        Scope scope = new Scope(project.getName());
                        switch (delta.getKind()) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                ProjectChangeListener.this.fSubsystem.unregisterScope(scope, ProjectChangeListener.this.NULL_PROGRESS_MONITOR);
                                break;
                            }
                            case 4: {
                                if ((delta.getFlags() & 0x4000) == 0 || !project.isOpen()) break;
                                ProjectChangeListener.this.fSubsystem.checkProject(project, ProjectChangeListener.this.NULL_PROGRESS_MONITOR);
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
        }
    }
}

