/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.subsystems;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.indexer.IStandaloneScannerInfoProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.Serializer;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.contentassist.Proposal;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerProgress;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerTask;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraph;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.subsystems.ProjectChangeListener;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitor;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitorFactory;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCIndexSubsystem
extends SubSystem
implements ICIndexSubsystem {
    private Set<IProject> fInitializedProjects;
    private ProjectChangeListener fProjectOpenListener;

    protected RemoteCIndexSubsystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
        super.initializeSubSystem(monitor);
        this.fInitializedProjects = new HashSet<IProject>();
        this.fProjectOpenListener = new ProjectChangeListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fProjectOpenListener);
        this.getDataStore().activateMiner("org.eclipse.ptp.internal.rdt.core.miners.CDTMiner");
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProjectOpenListener);
        this.fInitializedProjects = null;
    }

    public IStatus startIndexOfScope(Scope scope, IStandaloneScannerInfoProvider provider, IProgressMonitor monitor) {
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
            monitor.beginTask(Messages.getString("RemoteCIndexSubsystem.0"), 100);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_INDEX_START");
            if (queryCmd != null) {
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                DataElement scopeElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
                args.add(scopeElement);
                String serializedProvider = null;
                try {
                    serializedProvider = Serializer.serialize((Object)provider);
                }
                catch (IOException e) {
                    RDTLog.logError((Throwable)e);
                }
                DataElement providerElement = dataStore.createObject(null, "Type.Index.ScannerInfoProvider", serializedProvider);
                args.add(providerElement);
                DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
                try {
                    smonitor.waitForUpdate(status, monitor);
                    if (monitor.isCanceled()) {
                        this.cancelOperation(monitor, status.getParent());
                    }
                }
                catch (Exception exception) {}
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus reindexScope(Scope scope, IStandaloneScannerInfoProvider provider, IProgressMonitor monitor) {
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            DataElement result = this.getDataStore().createObject(null, "Type.Index.Status", null);
            StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
            DataElement queryCmd = dataStore.localDescriptorQuery(result.getDescriptor(), "C_INDEX_REINDEX");
            if (queryCmd != null) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(scope.getName());
                String serializedProvider = null;
                try {
                    serializedProvider = Serializer.serialize((Object)provider);
                    System.out.println("length " + serializedProvider.length());
                }
                catch (IOException e) {
                    RDTLog.logError((Throwable)e);
                }
                DataElement providerElement = dataStore.createObject(null, "Type.Index.ScannerInfoProvider", serializedProvider);
                args.add((String)providerElement);
                DataElement status = dataStore.command(queryCmd, args, result);
                try {
                    Display.getCurrent();
                    String statValue = status.getName();
                    while (!statValue.equals("done") && !monitor.isCanceled()) {
                        Thread.sleep(100L);
                        statValue = status.getName();
                    }
                    monitor.done();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus indexDelta(Scope scope, IStandaloneScannerInfoProvider provider, List<ICElement> newElements, List<ICElement> changedElements, List<ICElement> deletedElements, IProgressMonitor monitor, RemoteIndexerTask task) {
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            DataElement result = this.getDataStore().createObject(null, "Type.Index.Status", "index");
            StatusMonitorFactory.getInstance().getStatusMonitorFor(this._connectorService, dataStore);
            int workCount = newElements.size() + changedElements.size();
            monitor.beginTask("Incrementally Indexing...", workCount);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_INDEX_DELTA");
            if (queryCmd != null) {
                String remotePath;
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                DataElement scopeElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
                args.add(scopeElement);
                String serializedProvider = null;
                try {
                    serializedProvider = Serializer.serialize((Object)provider);
                }
                catch (IOException e) {
                    RDTLog.logError((Throwable)e);
                }
                DataElement providerElement = dataStore.createObject(null, "Type.Index.ScannerInfoProvider", serializedProvider);
                args.add(providerElement);
                for (ICElement element : newElements) {
                    remotePath = this.convertURIToRemotePath(element.getLocationURI());
                    DataElement addedElement = dataStore.createObject(null, "Type.Index.Delta.Added", remotePath);
                    args.add(addedElement);
                }
                for (ICElement element : changedElements) {
                    remotePath = this.convertURIToRemotePath(element.getLocationURI());
                    DataElement changedElement = dataStore.createObject(null, "Type.Index.Delta.Changed", remotePath);
                    args.add(changedElement);
                }
                for (ICElement element : deletedElements) {
                    remotePath = this.convertURIToRemotePath(element.getLocationURI());
                    DataElement deletedElement = dataStore.createObject(null, "Type.Index.Delta.Removed", remotePath);
                    args.add(deletedElement);
                }
                DataElement status = dataStore.command(queryCmd, args, result);
                while (!(status.getName().equals("done") || status.getName().equals("cancelled") || monitor.isCanceled())) {
                    RemoteIndexerProgress progress = this.getIndexerProgress(status);
                    task.updateProgressInformation(progress);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    if (monitor.isCanceled()) {
                        this.cancelOperation(monitor, status.getParent());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    private RemoteIndexerProgress getIndexerProgress(DataElement status) {
        int num = status.getNestedSize();
        if (num > 0) {
            Object result;
            block5: {
                DataElement element = status.get(num - 1);
                String data = element.getName();
                result = Serializer.deserialize((String)data);
                if (result != null && result instanceof RemoteIndexerProgress) break block5;
                return null;
            }
            try {
                RemoteIndexerProgress info = (RemoteIndexerProgress)result;
                return info;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IStatus registerScope(Scope scope, List<ICElement> elements, IProgressMonitor monitor) {
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
            monitor.beginTask(Messages.getString("RemoteCIndexSubsystem.3"), 100);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_SCOPE_REGISTER");
            if (queryCmd != null) {
                ArrayList<Object> args = new ArrayList<Object>();
                DataElement scopeElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
                args.add(scopeElement);
                Iterator<ICElement> iterator = elements.iterator();
                while (iterator.hasNext()) {
                    this.addElement(dataStore, args, iterator.next());
                }
                DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
                try {
                    smonitor.waitForUpdate(status, monitor);
                    if (monitor.isCanceled()) {
                        this.cancelOperation(monitor, status.getParent());
                    }
                }
                catch (Exception exception) {}
                int i = 0;
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    protected void addElement(DataStore dataStore, ArrayList<Object> args, ICElement element) {
        String filePath = null;
        if (element instanceof ITranslationUnit) {
            filePath = this.convertURIToRemotePath(element.getLocationURI());
        } else if (element instanceof ICContainer || element instanceof ICProject) {
            try {
                ICElement[] children = ((IParent)element).getChildren();
                int k = 0;
                while (k < children.length) {
                    this.addElement(dataStore, args, children[k]);
                    ++k;
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        if (filePath != null) {
            DataElement fileElement = dataStore.createObject(null, "Type.Scope.Filename", filePath);
            args.add(fileElement);
        }
    }

    protected URI convertRemotePathToURI(String path) throws URISyntaxException {
        return new URI("rse", this._host.getHostName(), path, null);
    }

    protected String convertURIToRemotePath(URI locationURI) {
        assert (locationURI.getScheme().equals("rse"));
        assert (this._host.getHostName().equals(locationURI.getHost()));
        return locationURI.getPath();
    }

    public IStatus unregisterScope(Scope scope, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(scope.getName());
        this.fInitializedProjects.remove(project);
        DataStore dataStore = this.getDataStore();
        if (dataStore != null) {
            StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
            monitor.beginTask(Messages.getString("RemoteCIndexSubsystem.4"), 100);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_SCOPE_UNREGISTER");
            if (queryCmd != null) {
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                DataElement scopeElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
                args.add(scopeElement);
                DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
                try {
                    smonitor.waitForUpdate(status, monitor);
                    if (monitor.isCanceled()) {
                        this.cancelOperation(monitor, status.getParent());
                    }
                }
                catch (Exception exception) {}
            }
        }
        return Status.OK_STATUS;
    }

    public OpenDeclarationResult openDeclaration(Scope scope, ITranslationUnit unit, String selectedText, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("RemoteCIndexSubsystem.9"), 100);
        Object result = this.sendRequest("C_NAVIGATION_OPEN_DECLARATION", new Object[]{scope, unit, selectedText, selectionStart, selectionLength}, monitor);
        if (result == null) {
            return OpenDeclarationResult.failureUnexpectedError();
        }
        return (OpenDeclarationResult)result;
    }

    public CalledByResult getCallers(Scope scope, ICElement subject, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RemoteCIndexSubsystem.5")) + subject, 100);
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_CALLERS", new Object[]{scope, this.getHostName(), subject}, null);
        if (result == null) {
            return new CalledByResult();
        }
        return (CalledByResult)result;
    }

    public CallsToResult getCallees(Scope scope, ICElement subject, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RemoteCIndexSubsystem.6")) + subject, 100);
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_CALLS", new Object[]{scope, this.getHostName(), subject}, null);
        if (result == null) {
            return new CallsToResult();
        }
        return (CallsToResult)result;
    }

    public ICElement[] getCHDefinitions(Scope scope, ICElement subject, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RemoteCIndexSubsystem.7")) + subject, 100);
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT", new Object[]{scope, this.getHostName(), subject}, null);
        if (result == null) {
            return new ICElement[0];
        }
        return (ICElement[])result;
    }

    public ICElement[] getCHDefinitions(Scope scope, ITranslationUnit unit, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RemoteCIndexSubsystem.7")) + unit, 100);
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY", new Object[]{scope, this.getHostName(), unit, selectionStart, selectionLength}, null);
        if (result == null) {
            return new ICElement[0];
        }
        return (ICElement[])result;
    }

    public List<RemoteSearchMatch> runQuery(Scope scope, RemoteSearchQuery query, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RemoteCIndexSubsystem.8")) + query.getScopeDescription(), 100);
        Object result = this.sendRequest("C_SEARCH_RUN_QUERY", new Object[]{scope, this.getHostName(), query}, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return (List)result;
    }

    public List<Proposal> computeCompletionProposals(Scope scope, RemoteContentAssistInvocationContext context, ITranslationUnit unit) {
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return Collections.emptyList();
        }
        DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_CONTENT_ASSIST_COMPUTE_PROPOSALS");
        if (queryCmd == null) {
            return Collections.emptyList();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        DataElement dataElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
        args.add(dataElement);
        args.add(this.createSerializableElement(dataStore, context));
        args.add(this.createSerializableElement(dataStore, unit));
        DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
        try {
            smonitor.waitForUpdate(status, (IProgressMonitor)monitor);
            if (monitor.isCanceled()) {
                this.cancelOperation((IProgressMonitor)monitor, status.getParent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataElement element = status.get(0);
        String data = element.getName();
        try {
            Object result = Serializer.deserialize((String)data);
            if (result == null || !(result instanceof List)) {
                return Collections.emptyList();
            }
            return (List)result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public THGraph computeTypeGraph(Scope scope, ICElement input, IProgressMonitor monitor) {
        Object result = this.sendRequest("C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH", new Object[]{scope, this.getHostName(), input}, monitor);
        if (result == null) {
            return new THGraph();
        }
        return (THGraph)result;
    }

    public ICElement[] findTypeHierarchyInput(Scope scope, ICElement memberInput) {
        Object result = this.sendRequest("C_TYPE_HIERARCHY_FIND_INPUT1", new Object[]{scope, this.getHostName(), memberInput}, null);
        if (result == null) {
            return new ICElement[2];
        }
        return (ICElement[])result;
    }

    public ICElement[] findTypeHierarchyInput(Scope scope, ITranslationUnit unit, int selectionStart, int selectionLength) {
        Object result = this.sendRequest("C_TYPE_HIERARCHY_FIND_INPUT2", new Object[]{scope, this.getHostName(), unit, new Integer(selectionStart), new Integer(selectionLength)}, null);
        if (result == null) {
            return new ICElement[2];
        }
        return (ICElement[])result;
    }

    public Object sendRequest(String requestType, Object[] arguments, IProgressMonitor monitor) {
        DataElement element;
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return null;
        }
        DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), requestType);
        if (queryCmd == null) {
            return null;
        }
        StatusMonitor statusMonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            DataElement dataElement;
            Object argument = objectArray[n2];
            if (argument instanceof Scope) {
                dataElement = dataStore.createObject(null, "Type.Scope.Scopename", ((Scope)argument).getName());
                args.add(dataElement);
            } else if (argument instanceof String) {
                dataElement = dataStore.createObject(null, "Type.Index.String", (String)argument);
                args.add(dataElement);
            } else if (argument instanceof Integer || argument instanceof Boolean || argument instanceof Character || argument instanceof Double || argument instanceof Float) {
                dataElement = dataStore.createObject(null, "Type.Index.String", argument.toString());
                args.add(dataElement);
            } else {
                args.add(this.createSerializableElement(dataStore, argument));
            }
            ++n2;
        }
        DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
        try {
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            statusMonitor.waitForUpdate(status, monitor);
            if (monitor.isCanceled()) {
                this.cancelOperation(monitor, status.getParent());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((element = status.get(0)) == null) {
            return null;
        }
        if ("error".equals(element.getType())) {
            RDTLog.logError((String)status.getValue());
            return null;
        }
        String data = element.getName();
        try {
            Object result = Serializer.deserialize((String)data);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private DataElement createSerializableElement(DataStore dataStore, Object object) {
        try {
            String serialized = Serializer.serialize((Object)object);
            return dataStore.createObject(null, "Type.Index.String", serialized);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected DataStore getDataStore() {
        IConnectorService connectorService = this.getConnectorService();
        if (connectorService instanceof DStoreConnectorService) {
            return ((DStoreConnectorService)connectorService).getDataStore();
        }
        return null;
    }

    protected void cancelOperation(IProgressMonitor monitor, DataElement cmd) throws InvocationTargetException, InterruptedException {
        DataStore dataStore = cmd.getDataStore();
        DataElement commandDescriptor = dataStore.findCommandDescriptor("C_CANCEL");
        if (commandDescriptor != null) {
            dataStore.command(commandDescriptor, cmd, false, true);
        }
    }

    public void checkAllProjects(IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                try {
                    if (project.hasNature("org.eclipse.ptp.rdt.core.remoteNature") && (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature"))) {
                        this.checkProject(project, monitor);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void checkProject(IProject project, IProgressMonitor monitor) {
        if (project == null || this.fInitializedProjects.contains(project)) {
            return;
        }
        try {
            this.initializeScope(project, monitor);
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
        }
    }

    private void initializeScope(IProject project, IProgressMonitor monitor) throws CoreException {
        IService service;
        ServiceModelManager serviceModelManager = ServiceModelManager.getInstance();
        IServiceConfiguration config = serviceModelManager.getActiveConfiguration(project);
        IServiceProvider provider = config.getServiceProvider(service = serviceModelManager.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (provider.getId().equals("org.eclipse.ptp.rdt.ui.RemoteCIndexServiceProvider")) {
            final LinkedList<ICElement> cElements = new LinkedList<ICElement>();
            IResourceVisitor fileCollector = new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ITranslationUnit tu;
                    if (resource instanceof IFile && (tu = CoreModelUtil.findTranslationUnit((IFile)((IFile)resource))) != null) {
                        cElements.add(tu);
                        return false;
                    }
                    return true;
                }
            };
            project.accept(fileCollector);
            Scope scope = new Scope(project.getName());
            this.unregisterScope(scope, monitor);
            this.registerScope(scope, cElements, monitor);
            this.fInitializedProjects.add(project);
        }
    }
}

